/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.desktop.window;

import androidx.compose.runtime.internal.StabilityInferred;
import com.abdownloadmanager.desktop.window.ChromeBrowser;
import com.abdownloadmanager.desktop.window.EdgeBrowser;
import com.abdownloadmanager.desktop.window.FirefoxBrowser;
import com.abdownloadmanager.desktop.window.OperaBrowser;
import com.abdownloadmanager.shared.util.BrowserType;
import ir.amirab.util.FileExtensionsKt;
import ir.amirab.util.platform.Platform;
import ir.amirab.util.platform.PlatformFInder;
import ir.amirab.util.platform.PlatformKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b'\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/abdownloadmanager/desktop/window/Browser;", "", "<init>", "()V", "getPossibleExecutablePaths", "", "Ljava/io/File;", "isInstalled", "", "openLink", "url", "", "getExecutablePath", "Companion", "app-utils"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nBrowserUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserUtil.kt\ncom/abdownloadmanager/desktop/window/Browser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n295#2,2:201\n*S KotlinDebug\n*F\n+ 1 BrowserUtil.kt\ncom/abdownloadmanager/desktop/window/Browser\n*L\n41#1:201,2\n*E\n"})
public abstract class Browser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    @NotNull
    public abstract List<File> getPossibleExecutablePaths();

    public final boolean isInstalled() {
        return this.getExecutablePath() != null;
    }

    public boolean openLink(@NotNull String url) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        File executablePath = this.getExecutablePath();
        if (executablePath == null) {
            return false;
        }
        Platform.Desktop desktop = PlatformKt.asDesktop((PlatformFInder)((PlatformFInder)Platform.Companion));
        if (Intrinsics.areEqual((Object)desktop, (Object)Platform.Desktop.Linux.INSTANCE)) {
            var5_4 = new String[]{executablePath.getPath(), url};
            stringArray = var5_4;
        } else if (Intrinsics.areEqual((Object)desktop, (Object)Platform.Desktop.Windows.INSTANCE)) {
            var5_4 = new String[]{executablePath.getPath(), url};
            stringArray = var5_4;
        } else if (Intrinsics.areEqual((Object)desktop, (Object)Platform.Desktop.MacOS.INSTANCE)) {
            String appFolder;
            String[] stringArray2 = FileExtensionsKt.toUpUntil((File)executablePath, Browser::openLink$lambda$0);
            String string = appFolder = stringArray2 != null ? stringArray2.getPath() : null;
            if (appFolder == null) {
                return false;
            }
            stringArray2 = new String[]{"open", "-a", appFolder, url};
            stringArray = stringArray2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String[] cmd = stringArray;
        Runtime.getRuntime().exec(cmd);
        return true;
    }

    @Nullable
    public final File getExecutablePath() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.getPossibleExecutablePaths();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!it.exists()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final boolean openLink$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string, (String)".app", (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/abdownloadmanager/desktop/window/Browser$Companion;", "", "<init>", "()V", "getBrowserByType", "Lcom/abdownloadmanager/desktop/window/Browser;", "type", "Lcom/abdownloadmanager/shared/util/BrowserType;", "app-utils"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Browser getBrowserByType(@NotNull BrowserType type) {
            Browser browser;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            BrowserType browserType = type;
            if (Intrinsics.areEqual((Object)browserType, (Object)BrowserType.Chrome.INSTANCE)) {
                browser = ChromeBrowser.INSTANCE;
            } else if (Intrinsics.areEqual((Object)browserType, (Object)BrowserType.Firefox.INSTANCE)) {
                browser = FirefoxBrowser.INSTANCE;
            } else if (Intrinsics.areEqual((Object)browserType, (Object)BrowserType.Edge.INSTANCE)) {
                browser = EdgeBrowser.INSTANCE;
            } else if (Intrinsics.areEqual((Object)browserType, (Object)BrowserType.Opera.INSTANCE)) {
                browser = OperaBrowser.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return browser;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

