/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.shared.downloaderinui.http.edit;

import androidx.compose.runtime.internal.StabilityInferred;
import com.abdownloadmanager.shared.downloaderinui.LinkChecker;
import com.abdownloadmanager.shared.downloaderinui.edit.CanEditDownloadResult;
import com.abdownloadmanager.shared.downloaderinui.edit.CanEditWarnings;
import com.abdownloadmanager.shared.downloaderinui.edit.DownloadConflictDetector;
import com.abdownloadmanager.shared.downloaderinui.http.add.HttpLinkChecker;
import com.abdownloadmanager.shared.downloaderinui.http.edit.EditDownloadChecker;
import ir.amirab.downloader.connection.response.HttpResponseInfo;
import ir.amirab.downloader.downloaditem.IDownloadItem;
import ir.amirab.downloader.downloaditem.http.HttpDownloadCredentials;
import ir.amirab.downloader.downloaditem.http.HttpDownloadItem;
import ir.amirab.util.FileNameValidator;
import ir.amirab.util.HttpUrlUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001B;\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J'\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/abdownloadmanager/shared/downloaderinui/http/edit/HttpEditDownloadChecker;", "Lcom/abdownloadmanager/shared/downloaderinui/http/edit/EditDownloadChecker;", "Lir/amirab/downloader/downloaditem/http/HttpDownloadItem;", "Lir/amirab/downloader/downloaditem/http/HttpDownloadCredentials;", "Lir/amirab/downloader/connection/response/HttpResponseInfo;", "Lcom/abdownloadmanager/shared/downloaderinui/http/add/HttpLinkChecker;", "currentDownloadItem", "Lkotlinx/coroutines/flow/MutableStateFlow;", "editedDownloadItem", "conflictDetector", "Lcom/abdownloadmanager/shared/downloaderinui/edit/DownloadConflictDetector;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "linkChecker", "<init>", "(Lkotlinx/coroutines/flow/MutableStateFlow;Lkotlinx/coroutines/flow/MutableStateFlow;Lcom/abdownloadmanager/shared/downloaderinui/edit/DownloadConflictDetector;Lkotlinx/coroutines/CoroutineScope;Lcom/abdownloadmanager/shared/downloaderinui/http/add/HttpLinkChecker;)V", "check", "", "Lcom/abdownloadmanager/shared/downloaderinui/edit/CanEditDownloadResult;", "current", "edited", "newLength", "", "(Lir/amirab/downloader/downloaditem/http/HttpDownloadItem;Lir/amirab/downloader/downloaditem/http/HttpDownloadItem;Ljava/lang/Long;)Lcom/abdownloadmanager/shared/downloaderinui/edit/CanEditDownloadResult;", "app"})
@StabilityInferred(parameters=0)
public final class HttpEditDownloadChecker
extends EditDownloadChecker<HttpDownloadItem, HttpDownloadCredentials, HttpResponseInfo, HttpLinkChecker> {
    public static final int $stable = 8;

    public HttpEditDownloadChecker(@NotNull MutableStateFlow<HttpDownloadItem> currentDownloadItem, @NotNull MutableStateFlow<HttpDownloadItem> editedDownloadItem, @NotNull DownloadConflictDetector conflictDetector, @NotNull CoroutineScope scope, @NotNull HttpLinkChecker linkChecker) {
        Intrinsics.checkNotNullParameter(currentDownloadItem, (String)"currentDownloadItem");
        Intrinsics.checkNotNullParameter(editedDownloadItem, (String)"editedDownloadItem");
        Intrinsics.checkNotNullParameter((Object)conflictDetector, (String)"conflictDetector");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)linkChecker, (String)"linkChecker");
        super(currentDownloadItem, editedDownloadItem, (LinkChecker)linkChecker, conflictDetector, scope);
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)editedDownloadItem), (Function2)((Function2)new Function2<HttpDownloadItem, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ HttpEditDownloadChecker this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.get_canEditResult().setValue((Object)CanEditDownloadResult.Waiting.INSTANCE);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(HttpDownloadItem p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)scope);
    }

    @Override
    public void check() {
        this.get_canEditResult().setValue((Object)CanEditDownloadResult.Waiting.INSTANCE);
        this.get_canEditResult().setValue((Object)this.check((HttpDownloadItem)this.getCurrentDownloadItem().getValue(), (HttpDownloadItem)this.getEditedDownloadItem().getValue(), (Long)((HttpLinkChecker)this.getLinkChecker()).getLength().getValue()));
    }

    private final CanEditDownloadResult check(HttpDownloadItem current, HttpDownloadItem edited, Long newLength) {
        if (Intrinsics.areEqual((Object)current, (Object)edited)) {
            return CanEditDownloadResult.NothingChanged.INSTANCE;
        }
        if (!HttpUrlUtils.INSTANCE.isValidUrl(edited.getLink())) {
            return CanEditDownloadResult.InvalidURL.INSTANCE;
        }
        if (!Intrinsics.areEqual((Object)edited.getName(), (Object)current.getName())) {
            if (!FileNameValidator.INSTANCE.isValidFileName(edited.getName())) {
                return CanEditDownloadResult.InvalidFileName.INSTANCE;
            }
            if (this.getConflictDetector().checkAlreadyExists((IDownloadItem)current, (IDownloadItem)edited)) {
                return CanEditDownloadResult.FileNameAlreadyExists.INSTANCE;
            }
        }
        List warnings = new ArrayList();
        Long l = newLength;
        if (l == null || current.getContentLength() != l.longValue()) {
            Long l2 = newLength;
            warnings.add(new CanEditWarnings.FileSizeNotMatch(current.getContentLength(), l2 != null ? l2 : -1L));
        }
        return new CanEditDownloadResult.CanEdit(warnings);
    }
}

