/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.shared.downloaderinui.edit;

import androidx.compose.runtime.internal.StabilityInferred;
import com.abdownloadmanager.shared.downloaderinui.edit.IDownloadConflictDetector;
import com.abdownloadmanager.shared.util.DownloadSystem;
import ir.amirab.downloader.downloaditem.IDownloadItem;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/abdownloadmanager/shared/downloaderinui/edit/DownloadConflictDetector;", "Lcom/abdownloadmanager/shared/downloaderinui/edit/IDownloadConflictDetector;", "Lir/amirab/downloader/downloaditem/IDownloadItem;", "downloadSystem", "Lcom/abdownloadmanager/shared/util/DownloadSystem;", "<init>", "(Lcom/abdownloadmanager/shared/util/DownloadSystem;)V", "checkAlreadyExists", "", "current", "edited", "app"})
@StabilityInferred(parameters=0)
public final class DownloadConflictDetector
implements IDownloadConflictDetector<IDownloadItem> {
    @NotNull
    private final DownloadSystem downloadSystem;
    public static final int $stable = 8;

    public DownloadConflictDetector(@NotNull DownloadSystem downloadSystem) {
        Intrinsics.checkNotNullParameter((Object)downloadSystem, (String)"downloadSystem");
        this.downloadSystem = downloadSystem;
    }

    @Override
    public boolean checkAlreadyExists(@NotNull IDownloadItem current, @NotNull IDownloadItem edited) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)edited, (String)"edited");
        File editedDownloadFile = this.downloadSystem.getDownloadFile(edited);
        boolean alreadyExists = editedDownloadFile.exists();
        if (alreadyExists) {
            return true;
        }
        return this.downloadSystem.getAllRegisteredDownloadFiles().contains(editedDownloadFile);
    }
}

