/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.KeyMethod;
import io.lindstrom.m3u8.model.SegmentKey;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

class SegmentKeyBuilder {
    private static final long INIT_BIT_METHOD = 1L;
    private long initBits = 1L;
    private KeyMethod method;
    private String uri;
    private String iv;
    private String keyFormat;
    private String keyFormatVersions;

    SegmentKeyBuilder() {
        if (!(this instanceof SegmentKey.Builder)) {
            throw new UnsupportedOperationException("Use: new SegmentKey.Builder()");
        }
    }

    public final SegmentKey.Builder from(SegmentKey instance) {
        Optional<String> keyFormatVersionsOptional;
        Optional<String> keyFormatOptional;
        Optional<String> ivOptional;
        Objects.requireNonNull(instance, "instance");
        this.method(instance.method());
        Optional<String> uriOptional = instance.uri();
        if (uriOptional.isPresent()) {
            this.uri(uriOptional);
        }
        if ((ivOptional = instance.iv()).isPresent()) {
            this.iv(ivOptional);
        }
        if ((keyFormatOptional = instance.keyFormat()).isPresent()) {
            this.keyFormat(keyFormatOptional);
        }
        if ((keyFormatVersionsOptional = instance.keyFormatVersions()).isPresent()) {
            this.keyFormatVersions(keyFormatVersionsOptional);
        }
        return (SegmentKey.Builder)this;
    }

    public final SegmentKey.Builder method(KeyMethod method) {
        this.method = Objects.requireNonNull(method, "method");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (SegmentKey.Builder)this;
    }

    public final SegmentKey.Builder uri(String uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
        return (SegmentKey.Builder)this;
    }

    public final SegmentKey.Builder uri(Optional<String> uri) {
        this.uri = uri.orElse(null);
        return (SegmentKey.Builder)this;
    }

    public final SegmentKey.Builder iv(String iv) {
        this.iv = Objects.requireNonNull(iv, "iv");
        return (SegmentKey.Builder)this;
    }

    public final SegmentKey.Builder iv(Optional<String> iv) {
        this.iv = iv.orElse(null);
        return (SegmentKey.Builder)this;
    }

    public final SegmentKey.Builder keyFormat(String keyFormat) {
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        return (SegmentKey.Builder)this;
    }

    public final SegmentKey.Builder keyFormat(Optional<String> keyFormat) {
        this.keyFormat = keyFormat.orElse(null);
        return (SegmentKey.Builder)this;
    }

    public final SegmentKey.Builder keyFormatVersions(String keyFormatVersions) {
        this.keyFormatVersions = Objects.requireNonNull(keyFormatVersions, "keyFormatVersions");
        return (SegmentKey.Builder)this;
    }

    public final SegmentKey.Builder keyFormatVersions(Optional<String> keyFormatVersions) {
        this.keyFormatVersions = keyFormatVersions.orElse(null);
        return (SegmentKey.Builder)this;
    }

    public SegmentKey build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableSegmentKey(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("method");
        }
        return "Cannot build SegmentKey, some of required attributes are not set " + attributes;
    }

    private static final class ImmutableSegmentKey
    implements SegmentKey {
        private final KeyMethod method;
        private final String uri;
        private final String iv;
        private final String keyFormat;
        private final String keyFormatVersions;

        private ImmutableSegmentKey(SegmentKeyBuilder builder) {
            this.method = builder.method;
            this.uri = builder.uri;
            this.iv = builder.iv;
            this.keyFormat = builder.keyFormat;
            this.keyFormatVersions = builder.keyFormatVersions;
        }

        @Override
        public KeyMethod method() {
            return this.method;
        }

        @Override
        public Optional<String> uri() {
            return Optional.ofNullable(this.uri);
        }

        @Override
        public Optional<String> iv() {
            return Optional.ofNullable(this.iv);
        }

        @Override
        public Optional<String> keyFormat() {
            return Optional.ofNullable(this.keyFormat);
        }

        @Override
        public Optional<String> keyFormatVersions() {
            return Optional.ofNullable(this.keyFormatVersions);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableSegmentKey && this.equalTo((ImmutableSegmentKey)another);
        }

        private boolean equalTo(ImmutableSegmentKey another) {
            return this.method.equals((Object)another.method) && Objects.equals(this.uri, another.uri) && Objects.equals(this.iv, another.iv) && Objects.equals(this.keyFormat, another.keyFormat) && Objects.equals(this.keyFormatVersions, another.keyFormatVersions);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.method.hashCode();
            h += (h << 5) + Objects.hashCode(this.uri);
            h += (h << 5) + Objects.hashCode(this.iv);
            h += (h << 5) + Objects.hashCode(this.keyFormat);
            h += (h << 5) + Objects.hashCode(this.keyFormatVersions);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SegmentKey{");
            builder.append("method=").append((Object)this.method);
            if (this.uri != null) {
                builder.append(", ");
                builder.append("uri=").append(this.uri);
            }
            if (this.iv != null) {
                builder.append(", ");
                builder.append("iv=").append(this.iv);
            }
            if (this.keyFormat != null) {
                builder.append(", ");
                builder.append("keyFormat=").append(this.keyFormat);
            }
            if (this.keyFormatVersions != null) {
                builder.append(", ");
                builder.append("keyFormatVersions=").append(this.keyFormatVersions);
            }
            return builder.append("}").toString();
        }
    }
}

