/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.PreloadHint;
import io.lindstrom.m3u8.model.PreloadHintType;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

class PreloadHintBuilder {
    private static final long INIT_BIT_TYPE = 1L;
    private static final long INIT_BIT_URI = 2L;
    private long initBits = 3L;
    private PreloadHintType type;
    private String uri;
    private Long byteRangeStart;
    private Long byteRangeLength;

    PreloadHintBuilder() {
        if (!(this instanceof PreloadHint.Builder)) {
            throw new UnsupportedOperationException("Use: new PreloadHint.Builder()");
        }
    }

    public final PreloadHint.Builder from(PreloadHint instance) {
        Optional<Long> byteRangeLengthOptional;
        Objects.requireNonNull(instance, "instance");
        this.type(instance.type());
        this.uri(instance.uri());
        Optional<Long> byteRangeStartOptional = instance.byteRangeStart();
        if (byteRangeStartOptional.isPresent()) {
            this.byteRangeStart(byteRangeStartOptional);
        }
        if ((byteRangeLengthOptional = instance.byteRangeLength()).isPresent()) {
            this.byteRangeLength(byteRangeLengthOptional);
        }
        return (PreloadHint.Builder)this;
    }

    public final PreloadHint.Builder type(PreloadHintType type) {
        this.type = Objects.requireNonNull(type, "type");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (PreloadHint.Builder)this;
    }

    public final PreloadHint.Builder uri(String uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return (PreloadHint.Builder)this;
    }

    public final PreloadHint.Builder byteRangeStart(long byteRangeStart) {
        this.byteRangeStart = byteRangeStart;
        return (PreloadHint.Builder)this;
    }

    public final PreloadHint.Builder byteRangeStart(Optional<Long> byteRangeStart) {
        this.byteRangeStart = byteRangeStart.orElse(null);
        return (PreloadHint.Builder)this;
    }

    public final PreloadHint.Builder byteRangeLength(long byteRangeLength) {
        this.byteRangeLength = byteRangeLength;
        return (PreloadHint.Builder)this;
    }

    public final PreloadHint.Builder byteRangeLength(Optional<Long> byteRangeLength) {
        this.byteRangeLength = byteRangeLength.orElse(null);
        return (PreloadHint.Builder)this;
    }

    public PreloadHint build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutablePreloadHint(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("type");
        }
        if ((this.initBits & 2L) != 0L) {
            attributes.add("uri");
        }
        return "Cannot build PreloadHint, some of required attributes are not set " + attributes;
    }

    private static final class ImmutablePreloadHint
    implements PreloadHint {
        private final PreloadHintType type;
        private final String uri;
        private final Long byteRangeStart;
        private final Long byteRangeLength;

        private ImmutablePreloadHint(PreloadHintBuilder builder) {
            this.type = builder.type;
            this.uri = builder.uri;
            this.byteRangeStart = builder.byteRangeStart;
            this.byteRangeLength = builder.byteRangeLength;
        }

        @Override
        public PreloadHintType type() {
            return this.type;
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public Optional<Long> byteRangeStart() {
            return Optional.ofNullable(this.byteRangeStart);
        }

        @Override
        public Optional<Long> byteRangeLength() {
            return Optional.ofNullable(this.byteRangeLength);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutablePreloadHint && this.equalTo((ImmutablePreloadHint)another);
        }

        private boolean equalTo(ImmutablePreloadHint another) {
            return this.type.equals((Object)another.type) && this.uri.equals(another.uri) && Objects.equals(this.byteRangeStart, another.byteRangeStart) && Objects.equals(this.byteRangeLength, another.byteRangeLength);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.type.hashCode();
            h += (h << 5) + this.uri.hashCode();
            h += (h << 5) + Objects.hashCode(this.byteRangeStart);
            h += (h << 5) + Objects.hashCode(this.byteRangeLength);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PreloadHint{");
            builder.append("type=").append((Object)this.type);
            builder.append(", ");
            builder.append("uri=").append(this.uri);
            if (this.byteRangeStart != null) {
                builder.append(", ");
                builder.append("byteRangeStart=").append(this.byteRangeStart);
            }
            if (this.byteRangeLength != null) {
                builder.append(", ");
                builder.append("byteRangeLength=").append(this.byteRangeLength);
            }
            return builder.append("}").toString();
        }
    }
}

