/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.Channels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class ChannelsBuilder {
    private static final long INIT_BIT_COUNT = 1L;
    private long initBits = 1L;
    private int count;
    private List<String> objectCodingIdentifiers = new ArrayList<String>();

    ChannelsBuilder() {
        if (!(this instanceof Channels.Builder)) {
            throw new UnsupportedOperationException("Use: new Channels.Builder()");
        }
    }

    public final Channels.Builder from(Channels instance) {
        Objects.requireNonNull(instance, "instance");
        this.count(instance.count());
        this.addAllObjectCodingIdentifiers(instance.objectCodingIdentifiers());
        return (Channels.Builder)this;
    }

    public final Channels.Builder count(int count) {
        this.count = count;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (Channels.Builder)this;
    }

    public final Channels.Builder addObjectCodingIdentifiers(String element) {
        this.objectCodingIdentifiers.add(Objects.requireNonNull(element, "objectCodingIdentifiers element"));
        return (Channels.Builder)this;
    }

    public final Channels.Builder addObjectCodingIdentifiers(String ... elements) {
        for (String element : elements) {
            this.objectCodingIdentifiers.add(Objects.requireNonNull(element, "objectCodingIdentifiers element"));
        }
        return (Channels.Builder)this;
    }

    public final Channels.Builder objectCodingIdentifiers(Iterable<String> elements) {
        this.objectCodingIdentifiers.clear();
        return this.addAllObjectCodingIdentifiers(elements);
    }

    public final Channels.Builder addAllObjectCodingIdentifiers(Iterable<String> elements) {
        for (String element : elements) {
            this.objectCodingIdentifiers.add(Objects.requireNonNull(element, "objectCodingIdentifiers element"));
        }
        return (Channels.Builder)this;
    }

    public Channels build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableChannels(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("count");
        }
        return "Cannot build Channels, some of required attributes are not set " + attributes;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static final class ImmutableChannels
    implements Channels {
        private final int count;
        private final List<String> objectCodingIdentifiers;

        private ImmutableChannels(ChannelsBuilder builder) {
            this.count = builder.count;
            this.objectCodingIdentifiers = ChannelsBuilder.createUnmodifiableList(true, builder.objectCodingIdentifiers);
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public List<String> objectCodingIdentifiers() {
            return this.objectCodingIdentifiers;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableChannels && this.equalTo((ImmutableChannels)another);
        }

        private boolean equalTo(ImmutableChannels another) {
            return this.count == another.count && this.objectCodingIdentifiers.equals(another.objectCodingIdentifiers);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.count;
            h += (h << 5) + this.objectCodingIdentifiers.hashCode();
            return h;
        }

        public String toString() {
            return "Channels{count=" + this.count + ", objectCodingIdentifiers=" + this.objectCodingIdentifiers + "}";
        }
    }
}

