/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.desktop.win;

import com.github.markusbernhardt.proxy.ProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.browser.ie.IELocalByPassFilter;
import com.github.markusbernhardt.proxy.selector.fixed.FixedProxySelector;
import com.github.markusbernhardt.proxy.selector.fixed.FixedSocksSelector;
import com.github.markusbernhardt.proxy.selector.misc.ProtocolDispatchSelector;
import com.github.markusbernhardt.proxy.selector.whitelist.ProxyBypassListSelector;
import com.github.markusbernhardt.proxy.util.Logger;
import com.github.markusbernhardt.proxy.util.ProxyException;
import com.github.markusbernhardt.proxy.util.ProxyUtil;
import com.github.markusbernhardt.proxy.util.UriFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Properties;

public abstract class CommonWindowsSearchStrategy
implements ProxySearchStrategy {
    protected ProxySelector setByPassListOnSelector(String bypassList, ProtocolDispatchSelector ps) {
        if (bypassList != null && bypassList.trim().length() > 0) {
            ProxyBypassListSelector result;
            if ("<local>".equals(bypassList.trim())) {
                result = this.buildLocalBypassSelector(ps);
            } else {
                bypassList = bypassList.replace(';', ',');
                result = new ProxyBypassListSelector(bypassList, (ProxySelector)ps);
            }
            return result;
        }
        return ps;
    }

    private ProxyBypassListSelector buildLocalBypassSelector(ProtocolDispatchSelector ps) {
        ArrayList<UriFilter> localBypassFilter = new ArrayList<UriFilter>();
        localBypassFilter.add(new IELocalByPassFilter());
        return new ProxyBypassListSelector(localBypassFilter, (ProxySelector)ps);
    }

    private void addFallbackSelector(Properties settings, ProtocolDispatchSelector ps) {
        String proxy = settings.getProperty("default");
        if (proxy != null) {
            ps.setFallbackSelector(ProxyUtil.parseProxySettings(proxy));
        }
    }

    private void addSelectorForProtocol(Properties settings, String protocol, ProtocolDispatchSelector ps) {
        String proxy = settings.getProperty(protocol);
        if (proxy != null) {
            FixedProxySelector protocolSelector = ProxyUtil.parseProxySettings(proxy);
            ps.setSelector(protocol, protocolSelector);
        }
    }

    protected Properties parseProxyList(String proxyString) throws ProxyException {
        Properties p = new Properties();
        if (proxyString.indexOf(61) == -1) {
            p.setProperty("default", proxyString);
        } else {
            try {
                proxyString = proxyString.replace(';', '\n');
                p.load(new ByteArrayInputStream(proxyString.getBytes("ISO-8859-1")));
            }
            catch (IOException e) {
                Logger.log(this.getClass(), Logger.LogLevel.ERROR, "Error reading IE settings as properties: {}", e);
                throw new ProxyException(e);
            }
        }
        return p;
    }

    protected ProtocolDispatchSelector buildProtocolDispatchSelector(Properties properties) {
        ProtocolDispatchSelector ps = new ProtocolDispatchSelector();
        this.addSelectorForProtocol(properties, "http", ps);
        this.addSelectorForProtocol(properties, "https", ps);
        this.addSelectorForProtocol(properties, "ftp", ps);
        this.addSelectorForProtocol(properties, "gopher", ps);
        this.addFallbackSelector(properties, ps);
        String socksProperties = properties.getProperty("socks");
        if (socksProperties != null) {
            String[] hostAndPort = socksProperties.split(":");
            String host = "";
            int port = 0;
            if (hostAndPort.length > 0) {
                host = hostAndPort[0];
            }
            if (hostAndPort.length > 1) {
                try {
                    port = Integer.parseInt(hostAndPort[1]);
                }
                catch (NumberFormatException e) {
                    Logger.log(CommonWindowsSearchStrategy.class, Logger.LogLevel.WARNING, "Cannot parse SOCKS proxy port {}", hostAndPort[1]);
                }
            }
            ps.setFallbackSelector(new FixedSocksSelector(host, port));
        }
        return ps;
    }
}

