/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.downloader.destination;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.FileHandle;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u0003J\u001a\u0010\u001f\u001a\u00020\u00192\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00190!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lir/amirab/downloader/destination/DestWriter;", "", "id", "", "file", "Ljava/io/File;", "seekPos", "writer", "Lokio/FileHandle;", "<init>", "(JLjava/io/File;JLokio/FileHandle;)V", "getId", "()J", "getFile", "()Ljava/io/File;", "getSeekPos", "setSeekPos", "(J)V", "getWriter", "()Lokio/FileHandle;", "status", "Lir/amirab/downloader/destination/DestWriter$Status;", "sink", "Lokio/Sink;", "prepare", "", "release", "write", "buffer", "Lokio/Buffer;", "length", "use", "block", "Lkotlin/Function1;", "Status", "core"})
public final class DestWriter {
    private final long id;
    @NotNull
    private final File file;
    private long seekPos;
    @NotNull
    private final FileHandle writer;
    @NotNull
    private Status status;
    @Nullable
    private transient Sink sink;

    public DestWriter(long id, @NotNull File file, long seekPos, @NotNull FileHandle writer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.id = id;
        this.file = file;
        this.seekPos = seekPos;
        this.writer = writer;
        this.status = Status.NotPrepared;
    }

    public final long getId() {
        return this.id;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final long getSeekPos() {
        return this.seekPos;
    }

    public final void setSeekPos(long l) {
        this.seekPos = l;
    }

    @NotNull
    public final FileHandle getWriter() {
        return this.writer;
    }

    public final synchronized void prepare() {
        if (this.status != Status.NotPrepared) {
            throw new IllegalStateException(("already prepared : status=" + this.status).toString());
        }
        if (!this.file.exists()) {
            throw new IllegalStateException("file not exists, can't prepare file".toString());
        }
        this.status = Status.Preparing;
        this.sink = this.writer.sink(this.seekPos);
        this.status = Status.Prepared;
    }

    public final synchronized void release() {
        Sink sink = this.sink;
        if (sink != null) {
            sink.close();
        }
        this.status = Status.NotPrepared;
    }

    public final void write(@NotNull Buffer buffer, long length) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Status currentStatus = this.status;
        if (currentStatus == Status.NotPrepared) {
            throw new Exception("first prepare");
        }
        if (currentStatus == Status.Finished) {
            throw new Exception("finished still writing?");
        }
        if (currentStatus == Status.Prepared) {
            this.status = Status.Writing;
        }
        Sink sink = this.sink;
        Intrinsics.checkNotNull((Object)sink);
        sink.write(buffer, length);
        this.seekPos += length;
    }

    public static /* synthetic */ void write$default(DestWriter destWriter, Buffer buffer, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = buffer.size();
        }
        destWriter.write(buffer, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void use(@NotNull Function1<? super DestWriter, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.prepare();
        try {
            block.invoke((Object)this);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                this.release();
            }
            catch (Exception exception) {}
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lir/amirab/downloader/destination/DestWriter$Status;", "", "<init>", "(Ljava/lang/String;I)V", "NotPrepared", "Preparing", "Prepared", "Writing", "Finished", "core"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status NotPrepared = new Status();
        public static final /* enum */ Status Preparing = new Status();
        public static final /* enum */ Status Prepared = new Status();
        public static final /* enum */ Status Writing = new Status();
        public static final /* enum */ Status Finished = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.NotPrepared, Status.Preparing, Status.Prepared, Status.Writing, Status.Finished};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

