/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.Body;
import org.http4k.filter.CompressionResult;
import org.http4k.filter.GZippingInputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0007\u001a\u00020\u0002*\u00020\u0002\u001a=\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\t0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0015"}, d2={"gzipped", "Lorg/http4k/filter/CompressionResult;", "Lorg/http4k/core/Body;", "compressionLevel", "", "gunzipped", "gzippedStream", "gunzippedStream", "sampleStream", "T", "sourceStream", "Ljava/io/InputStream;", "actionIfEmpty", "Lkotlin/Function0;", "actionIfHasContent", "Lkotlin/Function1;", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "GZIPOutputStreamWith", "Ljava/util/zip/GZIPOutputStream;", "out", "Ljava/io/OutputStream;", "http4k-core"})
@SourceDebugExtension(value={"SMAP\nGzip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Gzip.kt\norg/http4k/filter/GzipKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n1#2:263\n*E\n"})
public final class GzipKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final CompressionResult gzipped(@NotNull Body $this$gzipped, int compressionLevel) {
        CompressionResult compressionResult;
        Intrinsics.checkNotNullParameter((Object)$this$gzipped, (String)"<this>");
        byte[] byArray = $this$gzipped.getPayload().array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        if (byArray.length == 0) {
            compressionResult = new CompressionResult(Body.EMPTY, null);
        } else {
            ByteArrayOutputStream $this$gzipped_u24lambda_u240 = new ByteArrayOutputStream();
            boolean bl = false;
            Closeable closeable = GzipKt.GZIPOutputStreamWith($this$gzipped_u24lambda_u240, compressionLevel);
            Throwable throwable2 = null;
            try {
                GZIPOutputStream it = (GZIPOutputStream)closeable;
                boolean bl2 = false;
                it.write($this$gzipped.getPayload().array());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap($this$gzipped_u24lambda_u240.toByteArray());
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
            compressionResult = new CompressionResult(Body.Companion.create(byteBuffer), "gzip");
        }
        return compressionResult;
    }

    public static /* synthetic */ CompressionResult gzipped$default(Body body, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return GzipKt.gzipped(body, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Body gunzipped(@NotNull Body $this$gunzipped) {
        Body body;
        Intrinsics.checkNotNullParameter((Object)$this$gunzipped, (String)"<this>");
        byte[] byArray = $this$gunzipped.getPayload().array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        if (byArray.length == 0) {
            body = Body.EMPTY;
        } else {
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable2 = null;
            try {
                ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                ByteStreamsKt.copyTo$default((InputStream)new GZIPInputStream(new ByteArrayInputStream($this$gunzipped.getPayload().array())), (OutputStream)it, (int)0, (int)2, null);
                ByteBuffer byteBuffer = ByteBuffer.wrap(it.toByteArray());
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
                Body body2 = Body.Companion.create(byteBuffer);
                body = body2;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
        }
        return body;
    }

    @NotNull
    public static final CompressionResult gzippedStream(@NotNull Body $this$gzippedStream, int compressionLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$gzippedStream, (String)"<this>");
        return (CompressionResult)GzipKt.sampleStream($this$gzippedStream.getStream(), GzipKt::gzippedStream$lambda$0, arg_0 -> GzipKt.gzippedStream$lambda$1(compressionLevel, arg_0));
    }

    public static /* synthetic */ CompressionResult gzippedStream$default(Body body, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return GzipKt.gzippedStream(body, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Body gunzippedStream(@NotNull Body $this$gunzippedStream) {
        Body body;
        Intrinsics.checkNotNullParameter((Object)$this$gunzippedStream, (String)"<this>");
        if ($this$gunzippedStream.getLength() != null) {
            Long l = $this$gunzippedStream.getLength();
            long l2 = 0L;
            if (l != null && l == l2) {
                body = Body.EMPTY;
                return body;
            }
        }
        body = (Body)GzipKt.sampleStream($this$gunzippedStream.getStream(), GzipKt::gunzippedStream$lambda$0, GzipKt::gunzippedStream$lambda$1);
        return body;
    }

    private static final <T> T sampleStream(InputStream sourceStream, Function0<? extends T> actionIfEmpty, Function1<? super InputStream, ? extends T> actionIfHasContent) {
        Object object;
        PushbackInputStream pushbackStream = new PushbackInputStream(sourceStream);
        int firstByte = pushbackStream.read();
        if (firstByte == -1) {
            object = actionIfEmpty.invoke();
        } else {
            pushbackStream.unread(firstByte);
            object = actionIfHasContent.invoke((Object)pushbackStream);
        }
        return (T)object;
    }

    private static final GZIPOutputStream GZIPOutputStreamWith(OutputStream out, int compressionLevel) {
        return new GZIPOutputStream(compressionLevel, out){
            {
                this.def.setLevel($compressionLevel);
            }
        };
    }

    private static final CompressionResult gzippedStream$lambda$0() {
        return new CompressionResult(Body.EMPTY, null);
    }

    private static final CompressionResult gzippedStream$lambda$1(int $compressionLevel, InputStream compressedStream) {
        Intrinsics.checkNotNullParameter((Object)compressedStream, (String)"compressedStream");
        return new CompressionResult(Body.Companion.create$default(Body.Companion, new GZippingInputStream(compressedStream, $compressionLevel), null, 2, null), "gzip");
    }

    private static final Body gunzippedStream$lambda$0() {
        return Body.EMPTY;
    }

    private static final Body gunzippedStream$lambda$1(InputStream compressedStream) {
        Intrinsics.checkNotNullParameter((Object)compressedStream, (String)"compressedStream");
        return Body.Companion.create$default(Body.Companion, new GZIPInputStream(compressedStream), null, 2, null);
    }
}

