/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.core;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012$\b\u0002\u0010\u0004\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006j\u0002`\u00070\u0005j\u0002`\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0000J\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J%\u0010\u0017\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006j\u0002`\u00070\u0005j\u0002`\bH\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032$\b\u0002\u0010\u0004\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006j\u0002`\u00070\u0005j\u0002`\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR-\u0010\u0004\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006j\u0002`\u00070\u0005j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/http4k/core/ContentType;", "", "value", "", "directives", "", "Lkotlin/Pair;", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Parameters;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getValue", "()Ljava/lang/String;", "getDirectives", "()Ljava/util/List;", "withNoDirectives", "withoutCharset", "toHeaderValue", "equalsIgnoringDirectives", "", "that", "structure", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "http4k-core"})
@SourceDebugExtension(value={"SMAP\nContentType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentType.kt\norg/http4k/core/ContentType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n774#2:57\n865#2,2:58\n1563#2:60\n1634#2,2:61\n1636#2:64\n1#3:63\n*S KotlinDebug\n*F\n+ 1 ContentType.kt\norg/http4k/core/ContentType\n*L\n13#1:57\n13#1:58,2\n18#1:60\n18#1:61,2\n18#1:64\n*E\n"})
public final class ContentType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private final List<Pair<String, String>> directives;
    @NotNull
    private static final ContentType APPLICATION_FORM_URLENCODED = org.http4k.core.ContentType$Companion.Text$default(Companion, "application/x-www-form-urlencoded", null, 2, null);
    @NotNull
    private static final ContentType APPLICATION_JSON = org.http4k.core.ContentType$Companion.Text$default(Companion, "application/json", null, 2, null);
    @NotNull
    private static final ContentType APPLICATION_ND_JSON = org.http4k.core.ContentType$Companion.Text$default(Companion, "application/x-ndjson", null, 2, null);
    @NotNull
    private static final ContentType APPLICATION_JRD_JSON = org.http4k.core.ContentType$Companion.Text$default(Companion, "application/jrd+json", null, 2, null);
    @NotNull
    private static final ContentType APPLICATION_LD_JSON = org.http4k.core.ContentType$Companion.Text$default(Companion, "application/ld+json", null, 2, null);
    @NotNull
    private static final ContentType APPLICATION_PDF = new ContentType("application/pdf", null, 2, null);
    @NotNull
    private static final ContentType APPLICATION_XML = org.http4k.core.ContentType$Companion.Text$default(Companion, "application/xml", null, 2, null);
    @NotNull
    private static final ContentType APPLICATION_YAML = org.http4k.core.ContentType$Companion.Text$default(Companion, "application/yaml", null, 2, null);
    @NotNull
    private static final ContentType APPLICATION_ZIP = new ContentType("application/zip", null, 2, null);
    @NotNull
    private static final ContentType MULTIPART_FORM_DATA = new ContentType("multipart/form-data", null, 2, null);
    @NotNull
    private static final ContentType MULTIPART_MIXED = new ContentType("multipart/mixed", null, 2, null);
    @NotNull
    private static final ContentType OCTET_STREAM = new ContentType("application/octet-stream", null, 2, null);
    @NotNull
    private static final ContentType TEXT_CSV = org.http4k.core.ContentType$Companion.Text$default(Companion, "text/csv", null, 2, null);
    @NotNull
    private static final ContentType TEXT_EVENT_STREAM = org.http4k.core.ContentType$Companion.Text$default(Companion, "text/event-stream", null, 2, null);
    @NotNull
    private static final ContentType TEXT_PLAIN = org.http4k.core.ContentType$Companion.Text$default(Companion, "text/plain", null, 2, null);
    @NotNull
    private static final ContentType TEXT_HTML = org.http4k.core.ContentType$Companion.Text$default(Companion, "text/html", null, 2, null);
    @NotNull
    private static final ContentType TEXT_XML = org.http4k.core.ContentType$Companion.Text$default(Companion, "text/xml", null, 2, null);
    @NotNull
    private static final ContentType TEXT_YAML = org.http4k.core.ContentType$Companion.Text$default(Companion, "text/yaml", null, 2, null);
    @NotNull
    private static final ContentType IMAGE_PNG = new ContentType("image/png", null, 2, null);
    @NotNull
    private static final ContentType IMAGE_JPG = new ContentType("image/jpeg", null, 2, null);

    public ContentType(@NotNull String value2, @NotNull List<Pair<String, String>> directives) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter(directives, (String)"directives");
        this.value = value2;
        this.directives = directives;
    }

    public /* synthetic */ ContentType(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, list);
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final List<Pair<String, String>> getDirectives() {
        return this.directives;
    }

    @NotNull
    public final ContentType withNoDirectives() {
        return ContentType.copy$default(this, null, CollectionsKt.emptyList(), 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContentType withoutCharset() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = this.directives;
        String string = null;
        ContentType contentType = this;
        boolean $i$f$filter = false;
        void var3_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            String string2 = (String)it.getFirst();
            Locale locale2 = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ROOT");
            String string3 = string2.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            if (!(!Intrinsics.areEqual((Object)string3, (Object)"charset"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return ContentType.copy$default(contentType, string, list, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toHeaderValue() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.directives;
        Collection collection = CollectionsKt.listOf((Object)this.value);
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            Object object2;
            Collection collection2;
            block4: {
                block3: {
                    void it;
                    void it2;
                    Pair pair = (Pair)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    object2 = it2.getFirst();
                    object = (String)it2.getSecond();
                    if (object == null) break block3;
                    String string = object;
                    Object object3 = object2;
                    boolean bl2 = false;
                    String string2 = "=" + (String)it;
                    object2 = object3;
                    object = string2;
                    if (string2 != null) break block4;
                }
                object = "";
            }
            collection2.add(object2 + (String)object);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)), (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null);
    }

    public final boolean equalsIgnoringDirectives(@NotNull ContentType that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return Intrinsics.areEqual((Object)this.withNoDirectives(), (Object)that.withNoDirectives());
    }

    @Nullable
    public final String structure() {
        MatchResult matchResult = Regex.find$default((Regex)new Regex("\\+(\\w*)$"), (CharSequence)this.value, (int)0, (int)2, null);
        return matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final List<Pair<String, String>> component2() {
        return this.directives;
    }

    @NotNull
    public final ContentType copy(@NotNull String value2, @NotNull List<Pair<String, String>> directives) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter(directives, (String)"directives");
        return new ContentType(value2, directives);
    }

    public static /* synthetic */ ContentType copy$default(ContentType contentType, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = contentType.value;
        }
        if ((n & 2) != 0) {
            list = contentType.directives;
        }
        return contentType.copy(string, list);
    }

    @NotNull
    public String toString() {
        return "ContentType(value=" + this.value + ", directives=" + this.directives + ")";
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = result * 31 + ((Object)this.directives).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentType)) {
            return false;
        }
        ContentType contentType = (ContentType)other;
        if (!Intrinsics.areEqual((Object)this.value, (Object)contentType.value)) {
            return false;
        }
        return Intrinsics.areEqual(this.directives, contentType.directives);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b-\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000fR\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000fR\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000fR\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000fR\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000fR\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u000fR\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u000fR\u0011\u0010,\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u000fR\u0011\u0010.\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u000fR\u0011\u00100\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u000fR\u0011\u00102\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u000fR\u0011\u00104\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u000f\u00a8\u00066"}, d2={"Lorg/http4k/core/ContentType$Companion;", "", "<init>", "()V", "Text", "Lorg/http4k/core/ContentType;", "value", "", "charset", "Ljava/nio/charset/Charset;", "MultipartFormWithBoundary", "boundary", "MultipartMixedWithBoundary", "APPLICATION_FORM_URLENCODED", "getAPPLICATION_FORM_URLENCODED", "()Lorg/http4k/core/ContentType;", "APPLICATION_JSON", "getAPPLICATION_JSON", "APPLICATION_ND_JSON", "getAPPLICATION_ND_JSON", "APPLICATION_JRD_JSON", "getAPPLICATION_JRD_JSON", "APPLICATION_LD_JSON", "getAPPLICATION_LD_JSON", "APPLICATION_PDF", "getAPPLICATION_PDF", "APPLICATION_XML", "getAPPLICATION_XML", "APPLICATION_YAML", "getAPPLICATION_YAML", "APPLICATION_ZIP", "getAPPLICATION_ZIP", "MULTIPART_FORM_DATA", "getMULTIPART_FORM_DATA", "MULTIPART_MIXED", "getMULTIPART_MIXED", "OCTET_STREAM", "getOCTET_STREAM", "TEXT_CSV", "getTEXT_CSV", "TEXT_EVENT_STREAM", "getTEXT_EVENT_STREAM", "TEXT_PLAIN", "getTEXT_PLAIN", "TEXT_HTML", "getTEXT_HTML", "TEXT_XML", "getTEXT_XML", "TEXT_YAML", "getTEXT_YAML", "IMAGE_PNG", "getIMAGE_PNG", "IMAGE_JPG", "getIMAGE_JPG", "http4k-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ContentType Text(@NotNull String value2, @Nullable Charset charset) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            String string = value2;
            Charset charset2 = charset;
            if (charset2 != null) {
                Charset charset3 = charset2;
                String string2 = string;
                boolean bl = false;
                String string3 = charset.name();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name(...)");
                String string4 = string3;
                Locale locale2 = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ROOT");
                String string5 = string4.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                pair = TuplesKt.to((Object)"charset", (Object)string5);
                string = string2;
            } else {
                pair = null;
            }
            List list = CollectionsKt.listOfNotNull(pair);
            String string6 = string;
            return new ContentType(string6, list);
        }

        public static /* synthetic */ ContentType Text$default(Companion companion, String string, Charset charset, int n, Object object) {
            if ((n & 2) != 0) {
                charset = Charsets.UTF_8;
            }
            return companion.Text(string, charset);
        }

        @NotNull
        public final ContentType MultipartFormWithBoundary(@NotNull String boundary) {
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            return new ContentType("multipart/form-data", CollectionsKt.listOf((Object)TuplesKt.to((Object)"boundary", (Object)boundary)));
        }

        @NotNull
        public final ContentType MultipartMixedWithBoundary(@NotNull String boundary) {
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            return new ContentType("multipart/mixed", CollectionsKt.listOf((Object)TuplesKt.to((Object)"boundary", (Object)boundary)));
        }

        @NotNull
        public final ContentType getAPPLICATION_FORM_URLENCODED() {
            return APPLICATION_FORM_URLENCODED;
        }

        @NotNull
        public final ContentType getAPPLICATION_JSON() {
            return APPLICATION_JSON;
        }

        @NotNull
        public final ContentType getAPPLICATION_ND_JSON() {
            return APPLICATION_ND_JSON;
        }

        @NotNull
        public final ContentType getAPPLICATION_JRD_JSON() {
            return APPLICATION_JRD_JSON;
        }

        @NotNull
        public final ContentType getAPPLICATION_LD_JSON() {
            return APPLICATION_LD_JSON;
        }

        @NotNull
        public final ContentType getAPPLICATION_PDF() {
            return APPLICATION_PDF;
        }

        @NotNull
        public final ContentType getAPPLICATION_XML() {
            return APPLICATION_XML;
        }

        @NotNull
        public final ContentType getAPPLICATION_YAML() {
            return APPLICATION_YAML;
        }

        @NotNull
        public final ContentType getAPPLICATION_ZIP() {
            return APPLICATION_ZIP;
        }

        @NotNull
        public final ContentType getMULTIPART_FORM_DATA() {
            return MULTIPART_FORM_DATA;
        }

        @NotNull
        public final ContentType getMULTIPART_MIXED() {
            return MULTIPART_MIXED;
        }

        @NotNull
        public final ContentType getOCTET_STREAM() {
            return OCTET_STREAM;
        }

        @NotNull
        public final ContentType getTEXT_CSV() {
            return TEXT_CSV;
        }

        @NotNull
        public final ContentType getTEXT_EVENT_STREAM() {
            return TEXT_EVENT_STREAM;
        }

        @NotNull
        public final ContentType getTEXT_PLAIN() {
            return TEXT_PLAIN;
        }

        @NotNull
        public final ContentType getTEXT_HTML() {
            return TEXT_HTML;
        }

        @NotNull
        public final ContentType getTEXT_XML() {
            return TEXT_XML;
        }

        @NotNull
        public final ContentType getTEXT_YAML() {
            return TEXT_YAML;
        }

        @NotNull
        public final ContentType getIMAGE_PNG() {
            return IMAGE_PNG;
        }

        @NotNull
        public final ContentType getIMAGE_JPG() {
            return IMAGE_JPG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

