/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.util;

import com.mikepenz.aboutlibraries.entity.Developer;
import com.mikepenz.aboutlibraries.entity.Funding;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.entity.License;
import com.mikepenz.aboutlibraries.entity.Organization;
import com.mikepenz.aboutlibraries.entity.Scm;
import com.mikepenz.aboutlibraries.util.MultiplatformExtensionsKt;
import com.mikepenz.aboutlibraries.util.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableList;
import kotlinx.collections.immutable.ImmutableSet;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"parseData", "Lcom/mikepenz/aboutlibraries/util/Result;", "json", "", "aboutlibraries-core"})
@SourceDebugExtension(value={"SMAP\nMultiplatformParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplatformParser.kt\ncom/mikepenz/aboutlibraries/util/MultiplatformParserKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1208#2,2:72\n1236#2,4:74\n1617#2,9:78\n1869#2:87\n1870#2:89\n1626#2:90\n1#3:88\n*S KotlinDebug\n*F\n+ 1 MultiplatformParser.kt\ncom/mikepenz/aboutlibraries/util/MultiplatformParserKt\n*L\n28#1:72,2\n28#1:74,4\n31#1:78,9\n31#1:87\n31#1:89\n31#1:90\n31#1:88\n*E\n"})
public final class MultiplatformParserKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Result parseData(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            void $this$associateByTo$iv$iv;
            JsonObject metaData = JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(json));
            List<License> licenses = MultiplatformExtensionsKt.forEachObject(MultiplatformExtensionsKt.getJSONObject(metaData, "licenses"), MultiplatformParserKt::parseData$lambda$0);
            Iterable $this$associateBy$iv = licenses;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                License license = (License)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.getHash(), element$iv$iv);
            }
            Map mappedLicenses = destination$iv$iv;
            List<Library> libraries = MultiplatformExtensionsKt.forEachObject(MultiplatformExtensionsKt.getJSONArray(metaData, "libraries"), arg_0 -> MultiplatformParserKt.parseData$lambda$2(mappedLicenses, arg_0));
            return new Result(libraries, licenses);
        }
        catch (Throwable t) {
            System.out.println((Object)("Failed to parse the meta data *.json file: " + t));
            return new Result(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
    }

    private static final License parseData$lambda$0(JsonObject $this$forEachObject, String key) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachObject, (String)"$this$forEachObject");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new License(MultiplatformExtensionsKt.getString($this$forEachObject, "name"), MultiplatformExtensionsKt.optString($this$forEachObject, "url"), MultiplatformExtensionsKt.optString($this$forEachObject, "year"), MultiplatformExtensionsKt.optString($this$forEachObject, "spdxId"), MultiplatformExtensionsKt.optString($this$forEachObject, "content"), key);
    }

    /*
     * WARNING - void declaration
     */
    private static final Library parseData$lambda$2(Map $mappedLicenses, JsonObject $this$forEachObject) {
        Scm scm;
        Organization organization;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$forEachObject, (String)"$this$forEachObject");
        Iterable $this$mapNotNull$iv = MultiplatformExtensionsKt.forEachString(MultiplatformExtensionsKt.optJSONArray($this$forEachObject, "licenses"), arg_0 -> MultiplatformParserKt.parseData$lambda$2$0($mappedLicenses, arg_0));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            License it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            License it = (License)element$iv$iv;
            boolean bl2 = false;
            if (it == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        HashSet libLicenses = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        Object object = MultiplatformExtensionsKt.optJSONArray($this$forEachObject, "developers");
        if (object == null || (object = MultiplatformExtensionsKt.forEachObject(object, MultiplatformParserKt::parseData$lambda$2$2)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object developers = object;
        JsonObject jsonObject = MultiplatformExtensionsKt.optJSONObject($this$forEachObject, "organization");
        if (jsonObject != null) {
            JsonObject it = jsonObject;
            boolean bl = false;
            String string = MultiplatformExtensionsKt.optString(it, "name");
            if (string == null) {
                string = "";
            }
            organization = new Organization(string, MultiplatformExtensionsKt.optString(it, "url"));
        } else {
            organization = null;
        }
        Organization organization2 = organization;
        JsonObject jsonObject2 = MultiplatformExtensionsKt.optJSONObject($this$forEachObject, "scm");
        if (jsonObject2 != null) {
            JsonObject it = jsonObject2;
            boolean bl = false;
            scm = new Scm(MultiplatformExtensionsKt.optString(it, "connection"), MultiplatformExtensionsKt.optString(it, "developerConnection"), MultiplatformExtensionsKt.optString(it, "url"));
        } else {
            scm = null;
        }
        Scm scm2 = scm;
        Set funding = CollectionsKt.toSet((Iterable)MultiplatformExtensionsKt.forEachObject(MultiplatformExtensionsKt.optJSONArray($this$forEachObject, "funding"), MultiplatformParserKt::parseData$lambda$2$5));
        String id = MultiplatformExtensionsKt.getString($this$forEachObject, "uniqueId");
        String string = MultiplatformExtensionsKt.optString($this$forEachObject, "artifactVersion");
        String string2 = MultiplatformExtensionsKt.optString($this$forEachObject, "name");
        if (string2 == null) {
            string2 = id;
        }
        return new Library(id, string, string2, MultiplatformExtensionsKt.optString($this$forEachObject, "description"), MultiplatformExtensionsKt.optString($this$forEachObject, "website"), (ImmutableList<Developer>)ExtensionsKt.toImmutableList((Iterable)((Iterable)developers)), organization2, scm2, (ImmutableSet<License>)ExtensionsKt.toImmutableSet((Iterable)libLicenses), (ImmutableSet<Funding>)ExtensionsKt.toImmutableSet((Iterable)funding), MultiplatformExtensionsKt.optString($this$forEachObject, "tag"));
    }

    private static final License parseData$lambda$2$0(Map $mappedLicenses, String $this$forEachString) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachString, (String)"$this$forEachString");
        return (License)$mappedLicenses.get($this$forEachString);
    }

    private static final Developer parseData$lambda$2$2(JsonObject $this$forEachObject) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachObject, (String)"$this$forEachObject");
        return new Developer(MultiplatformExtensionsKt.optString($this$forEachObject, "name"), MultiplatformExtensionsKt.optString($this$forEachObject, "organisationUrl"));
    }

    private static final Funding parseData$lambda$2$5(JsonObject $this$forEachObject) {
        Intrinsics.checkNotNullParameter((Object)$this$forEachObject, (String)"$this$forEachObject");
        return new Funding(MultiplatformExtensionsKt.getString($this$forEachObject, "platform"), MultiplatformExtensionsKt.getString($this$forEachObject, "url"));
    }
}

