﻿cr.define('options', function() {
  var OptionsPage = options.OptionsPage;

  function LabOptions() {
      OptionsPage.call(this, 'lab', templateData.labPageTabTitle, 'labPage');
  }

  cr.addSingletonGetter(LabOptions);

  LabOptions.prototype = {
    __proto__: options.OptionsPage.prototype,

    initializePage: function() {
      OptionsPage.prototype.initializePage.call(this);

      // Preferences.getInstance().addEventListener('se.browser.tray_msg_enable', function(e) {
      //   document.querySelector('[pref="se.browser.tray_no_receive"]').disabled = e.value && !e.value.value;
      //   if (e.value.value) {
      //     document.querySelector('[pref="se.browser.tray_no_receive"]').checked = true;
      //   }
      // });

      Preferences.getInstance().addEventListener('browser.snap_plugin.mode_setting', function(e) {
        if (e.value && e.value.value == 3) {
          $('screenshotSetting').disabled = true
        } else {
          $('screenshotSetting').disabled = false
        }
      });

      Preferences.getInstance().addEventListener('browser.kantu.enable_kandatu', function(e) {
        document.querySelector('[pref="browser.kantu.hide_kandatu_label"]').disabled = e.value&&!e.value.value;
        $("manage-kandatu-list").disabled = e.value&&!e.value.value;
      });

      $("manage-kandatu-list").onclick = function(event) {
        OptionsPage.navigateToPage("manageKandatuList");
      };
      $('certificate_list').onclick = function(event) {

        OptionsPage.navigateToPage("certificate");
      };
      
      Preferences.getInstance().addEventListener('browser.prerender_url_under_mouse.enable', function(e) {
        document.querySelector('[pref="browser.prerender_url_under_mouse.text_limit"]').disabled = !e.value.value;
      });

      document.querySelector('[pref="browser.prerender_url_under_mouse.text_limit"]').addEventListener('change', function() {
        if (this.value < 5) {
          this.value = 5;
        }
        if (this.value > 1000) {
          this.value = 1000;
        }
      }, false);

      chrome.send('getLowPowerLevel');
      $('select_low_power_level').onchange = function () {
        var power_select = $('select_low_power_level');
        var selectedIndex = power_select.selectedIndex;
        if (selectedIndex >= 0) {
          var selection = power_select.options[selectedIndex];
          chrome.send('setLowPowerLevel', [parseInt(selection.value)]);
        }
      };
    },

    onGetLowPowerLevel_: function (value) {
      if ($('select_low_power_level') && (value == '0' || value == '1' || value == '2')) {
        $('select_low_power_level').value = value;
      }
    },
  };

  LabOptions.onGetLowPowerLevel = function (value) {
    LabOptions.getInstance().onGetLowPowerLevel_(value);
  };

  LabOptions.PowerSaveSectionEnable = function (enable) {
    $$('#powersave').find(':checkbox,button,select').attr('disabled', !enable);
    $$('#powersave').find('#savepower_level_lable').attr('disabled', !enable);
  };

  return {
    LabOptions: LabOptions
  };
});
