// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

cr.define('options', function() {
  var OptionsPage = options.OptionsPage;

  function AppstoreNotifyOverlay() {
    OptionsPage.call(this,
      'appstoreNotify',
      '选项 - 广告过滤',
      'appstore-notify-overlay');
  }

  cr.addSingletonGetter(AppstoreNotifyOverlay);

  AppstoreNotifyOverlay.prototype = {
    // Inherit from OptionsPage.
    __proto__: OptionsPage.prototype,

    /**
     * Initialize the page.
     */
    initializePage: function() {

      // Call base class implementation to start preference initialization.
      OptionsPage.prototype.initializePage.call(this);

      $$('#appstore-notify-overlay .close').on('click', function() {
        OptionsPage.closeOverlay();
      });
      $$('#appstore-notify-overlay button.close').on('click', function() {
        var $checkbox = $$('#appstore-notify-overlay .action-area-center :checkbox');
        if ($checkbox[0].checked) {
          var crx = $checkbox.data('crx');
          if (crx) {
            var $link = $$('<a href="' + crx + '"></a>');
            $link[0].click();
          }
        }
      });
    }
  };

  // Export
  return {
    AppstoreNotifyOverlay: AppstoreNotifyOverlay
  };
});
