const utils = {
  getQueryString: (name) => {
    let reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
    let r = window.location.search.substr(1).match(reg);
    if (r != null) return unescape(r[2]);
    return null;
  },
  _$: (id) => {
    // 工具方法，获取当前DOM
    if (id.indexOf('.') > -1) {
      return document.querySelector(id);
    } else if (id.indexOf('#') > -1) { //id获取
      id = id.substr(1)
      return document.getElementById(id);
    } else if (id.indexOf('!') > -1) {
      return document.querySelectorAll('.' + id.substr(1));
    }
  },
  AppCmd: (type, par_1 = '', par_2 = '') => { //客户端方法 
    return new Promise((resolve, reject) => {
      try {
        external.AppCmd(external.GetSID(window), 'se_darkmode', type, par_1, par_2, (code, msg) => {
          console.log(code, msg);
          msg.indexOf('{') > -1 && (msg = JSON.parse(msg))
          resolve(msg)
        });
      } catch (err) {
        console.log('err：', err.message)
        let testData = utils.getQueryString('testDarkData')
        try {
          testData = eval(`(${testData})`)
        } catch {}
        if (testData) {
          resolve(testData)
        }
      }
    })
  },
  changeDarkMode: () => { //切换黑暗模式 
    utils.updateSlider()
    utils._$('.setting-popup').classList.remove('setting-day')
    utils._$('.setting-popup').classList.add('setting-dark')
  },
  changeDayMode: () => { //切换日常模式
    utils.updateSlider()
    utils._$('.setting-popup').classList.remove('setting-dark')
    utils._$('.setting-popup').classList.add('setting-day')
  },
  updateSlider: () =>{
    utils.AppCmd('GetDarkData').then(data => {
      var lf_val = data.opcity_size == 51 ? '33%' : (data.opcity_size / 154).toFixed(4) * 100 + '%';
      $('.drag-slider').style.left = lf_val; //154 = 153.6 = 256 *60% 
    })
  },
  send: (filename, data) => {
    var files = [];
    if (Object.prototype.toString.call(filename) == '[object String]') {
      files.push(filename);
    } else if (Object.prototype.toString.call(filename) == '[object Array]') {
      files = filename;
    } else {
      return;
    }
    files.forEach(function (item) {
      var params = '';
      if (data && typeof data == 'object') {
        for (var k in data) {
          params += k + '=' + data[k] + '&';
        }
      }
      new Image().src = 'https://dd.browser.360.cn/static/a/' + item + '?' + params + 'mid=' + utils.GetMID() + '&' +
        Date.now() + Math.random().toString().replace('0.', '').substr(0, 10);
    })
  },
  GetSID: () => {
    if (utils.sid) {
      return utils.sid;
    }
    try {
      utils.sid = external.GetSID(window);
      return utils.sid;
    } catch (e) {
      return '';
    }
  },
  GetMID: () => {
    if (utils.mid) {
      return utils.mid;
    }
    utils.mid = utils.GetSID() && external.GetMID(utils.sid);
    return utils.mid
  },
  GetVersion() {
    if (utils.ver) {
      return utils.ver
    }
    utils.ver = utils.GetSID() && external.GetVersion(utils.sid)
    return utils.ver
  },
  // 版本比较，ver1 >= ver2返回true
  verCompare(ver1, ver2) {
    const arr1 = ver1.split(".");
      const arr2 = ver2.split(".");
      const len = Math.max(arr1.length, arr2.length);
    for (let i = 0; i < len; i++) {
      const num1 = parseInt(arr1[i]) || 0;
        const num2 = parseInt(arr2[i]) || 0
      if (num1 > num2) {
        return true
      } else if (num1 < num2) {
        return false
      }
    }
    return true
  }
}