// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// TODO(kochi): Generalize the notification as a component and put it
// in js/cr/ui/notification.js .

cr.define('options', function() {
  const OptionsPage = options.OptionsPage;


  /////////////////////////////////////////////////////////////////////////////
  // LanguageOptions class:

  /**
   * Encapsulated handling of ChromeOS language options page.
   * @constructor
   */
  function Proxy360Options(model) {
    OptionsPage.call(this, 'proxy360', templateData.proxy360PageTabTitle,
                     'proxy360Page');
  }

  cr.addSingletonGetter(Proxy360Options);

  // Inherit Proxy360Options from OptionsPage.
  Proxy360Options.prototype = {
    __proto__: OptionsPage.prototype,

    /**
     * Initializes Proxy360Options page.
     * Calls base class implementation to starts preference initialization.
     */
    initializePage: function() {
      OptionsPage.prototype.initializePage.call(this);
      this.addEventListener('visibleChange', this.handleVisibleChange_.bind(this));

      $('proxy360ListsTextarea').addEventListener('focus', function(e) {
        $('proxy360ListsOverflow').style.display = 'none';
      });
      $('proxy360ListsTextarea').addEventListener('blur', function(e) {
        $('proxy360ListsOverflow').style.display = $('proxy360ListsTextarea').value?'none':'block';

        var list = [];
        list.push($('proxy360ListsTextarea').value);
        list.push($('proxy360ListsByPassTextarea').value);
        chrome.send('setProxySettings', list);
      });

      $('proxy360ListsByPassTextarea').addEventListener('blur', function(e) {
        var list = [];
        list.push($('proxy360ListsTextarea').value);
        list.push($('proxy360ListsByPassTextarea').value);
        chrome.send('setProxySettings', list);
      });
    },

    /**
     * Handles OptionsPage's visible property change event.
     * @param {Event} e Property change event.
     * @private
     */
    handleVisibleChange_: function(e) {
      if (this.visible) {
        chrome.send('getProxySettings');
      }

    }
  };

  Proxy360Options.onGetProxySettings = function (list) {
    $('proxy360ListsTextarea').value = list[0]||'';
    $('proxy360ListsByPassTextarea').value = list[1]||'';
    $('proxy360ListsOverflow').style.display = list[0]?'none':'block';
  };

  // Export
  return {
    Proxy360Options: Proxy360Options
  };
});
