// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

cr.define('options.passwordManager', function() {
  const ArrayDataModel = cr.ui.ArrayDataModel;
  const DeletableItemList = options.DeletableItemList;
  const DeletableItem = options.DeletableItem;
  const List = cr.ui.List;
  let curChangeAccount = -1
  /**
   * Creates a new passwords list item.
   * @param {Array} entry An array of the form [url, username, password]. When
   *     the list has been filtered, a fourth element [index] may be present.
   * @constructor
   * @extends {cr.ui.ListItem}
   */
  function PasswordListItem(entry, showPasswords) {
    var el = cr.doc.createElement('div');
    el.dataItem = entry;
    el.__proto__ = PasswordListItem.prototype;
    el.decorate(showPasswords);

    return el;
  }

  PasswordListItem.prototype = {
    __proto__: DeletableItem.prototype,

    /** @inheritDoc */
    decorate: function(showPasswords) {
      showPasswords = false
      DeletableItem.prototype.decorate.call(this);
      if (this.password) showPasswords = true;
      // The URL of the site.
      var urlLabel = this.ownerDocument.createElement('div');
      urlLabel.classList.add('favicon-cell');
      urlLabel.classList.add('weakrtl');
      urlLabel.classList.add('url');
      urlLabel.innerHTML = `
        <a target="_blank" title=${HTMLescape(this.url)} href=${HTMLescape(this.url)}>${this.urlReg || HTMLescape(this.url)}</a>
      `
      $$(urlLabel).children('a').on('click', ()=> {gif('1388.5493.gif')})
      // urlLabel.setAttribute('title', this.url);
      // urlLabel.setAttribute('href', this.url);
      // urlLabel.setAttribute('target', '_blank');
      // urlLabel.innerHTML = this.urlReg || this.url;
      urlLabel.style.backgroundImage = url('chrome://favicon/' + HTMLescape(this.url));
      this.contentElement.appendChild(urlLabel);

      // The stored username.
      var usernameLabel = this.ownerDocument.createElement('div');
      usernameLabel.className = 'name';
      usernameLabel.innerHTML = `<span class="name-text" title=${HTMLescape(this.username)}>${this.usernameReg || HTMLescape(this.username)}</span><span class="change-account">切换账号</span>`;
      $$(usernameLabel).find('.change-account').on('click', this.changeAccount.bind(this, $$(usernameLabel).find('.change-account')))
      this.contentElement.appendChild(usernameLabel);

      // The stored password.
      var passwordInputDiv = this.ownerDocument.createElement('div');
      passwordInputDiv.className = 'password';
      $$(passwordInputDiv).attr('data-url', this.url)
      $$(passwordInputDiv).attr('data-id', this.id)
      var passwordInput = this.ownerDocument.createElement('input');
      passwordInput.type = 'text';
      passwordInput.className = 'inactive-password';
      passwordInput.readOnly = true;
      passwordInput.value = this.password;
      passwordInputDiv.appendChild(passwordInput);
      var passwordInvisible = this.ownerDocument.createElement('div');
      passwordInvisible.className = 'password-invisible';
      passwordInvisible.innerHTML = `<i></i><i></i><i></i><i></i>`;
      passwordInputDiv.appendChild(passwordInvisible);
      var btns = this.ownerDocument.createElement('div');
      btns.className = 'password-btns'
      btns.innerHTML = `
        <div class="password-btns-svg show-password" ${this.password ? 'hidden' : ''} title="查看密码">
          <svg   viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
          <path fill-rule="evenodd" clip-rule="evenodd" d="M14.6533 8.0311L14.6795 8L14.6533 7.9689C13.3197 6.38334 11.315 4 8 4C4.68499 4 2.68032 6.38334 1.34667 7.9689L1.32051 8L1.34667 8.0311C2.68032 9.61666 4.68499 12 8 12C11.315 12 13.3197 9.61666 14.6533 8.0311ZM16 8C15.848 8.16625 15.6731 8.37673 15.4736 8.61672C14.1734 10.1812 11.8306 13 8 13C4.16936 13 1.82662 10.1812 0.526389 8.61672L0.526375 8.6167C0.32692 8.37672 0.151998 8.16625 0 8C0.152001 7.83375 0.326928 7.62327 0.526389 7.38328C1.82662 5.81883 4.16936 3 8 3C11.8306 3 14.1734 5.81883 15.4736 7.38328L15.4736 7.38329C15.6731 7.62328 15.848 7.83375 16 8ZM8 10C9.10457 10 10 9.10457 10 8C10 6.89543 9.10457 6 8 6C6.89543 6 6 6.89543 6 8C6 9.10457 6.89543 10 8 10Z" fill="currentColor" />
          </svg>
        </div>
        <div class="password-btns-svg hide-password" ${!this.password ? 'hidden' : ''} title="隐藏密码">
          <svg   viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
          <path fill-rule="evenodd" clip-rule="evenodd" d="M1.76923 4.55649C2.01417 4.42898 2.3161 4.52418 2.44361 4.76912C2.61838 5.10486 2.89124 5.4312 3.25796 5.73174L3.25796 5.73175C4.29389 6.58077 6.01193 7.16666 8.0001 7.16666C9.98827 7.16666 11.7063 6.58076 12.7422 5.73175L12.7422 5.73174C13.109 5.4312 13.3818 5.10485 13.5566 4.76913C13.6841 4.52419 13.986 4.42898 14.231 4.55649C14.4759 4.68399 14.5711 4.98592 14.4436 5.23086C14.1952 5.70801 13.8269 6.13573 13.3761 6.50518C13.1872 6.66 12.9824 6.80583 12.7633 6.94186L14.3536 8.53208C14.5488 8.72734 14.5488 9.04393 14.3536 9.23919C14.1583 9.43445 13.8417 9.43445 13.6464 9.23919L11.8321 7.42482C11.2255 7.6858 10.5503 7.88466 9.83027 8.01049L10.483 10.4465C10.5544 10.7132 10.3961 10.9874 10.1294 11.0588C9.86267 11.1303 9.5885 10.972 9.51704 10.7053L8.82845 8.13533C8.5564 8.15605 8.27992 8.16666 8.0001 8.16666C7.72022 8.16666 7.44367 8.15604 7.17155 8.13532L6.48296 10.7053C6.4115 10.972 6.13733 11.1303 5.87059 11.0588C5.60386 10.9874 5.44557 10.7132 5.51704 10.4465L6.16974 8.01045C5.4497 7.88462 4.77457 7.68574 4.16797 7.42476L2.35355 9.23919C2.15829 9.43445 1.84171 9.43445 1.64645 9.23919C1.45119 9.04393 1.45118 8.72734 1.64645 8.53208L3.23673 6.94179C3.01774 6.80577 2.81295 6.65997 2.62408 6.50518C2.17326 6.13572 1.80497 5.708 1.5566 5.23087C1.42909 4.98593 1.52429 4.684 1.76923 4.55649Z" fill="currentColor" />
          </svg>
        </div>
        <div class="password-btns-svg copy-password" title="复制密码">
          <svg   viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
          <path fill-rule="evenodd" clip-rule="evenodd" d="M6 3H12C12.5523 3 13 3.44772 13 4V10C13 10.5523 12.5523 11 12 11V12C13.1046 12 14 11.1046 14 10V4C14 2.89543 13.1046 2 12 2H6C4.89543 2 4 2.89543 4 4V10C4 10.0025 4 10.005 4.00001 10.0075V4L5 4C5 3.44772 5.44772 3 6 3Z" fill="currentColor" />
          <rect x="2.5" y="4.5" width="9" fill="transparent" height="9" rx="1.5" stroke="currentColor"/>
          </svg>
        </div>
      `;
      $$(btns).children('.show-password').on('click', this.showPassword.bind(this))
      $$(btns).children('.hide-password').on('click', this.hidePassword.bind(this, $$(passwordInputDiv)))
      $$(btns).children('.copy-password').on('click', this.copyPassword.bind(this))
      passwordInputDiv.appendChild(btns);
      if (showPasswords) {
        passwordInput.hidden = false
        passwordInvisible.hidden =  true
      } else {
        passwordInput.hidden = true
        passwordInvisible.hidden =  false
      }
      this.contentElement.appendChild(passwordInputDiv);

      // The stored close.
      var closeLabel = this.ownerDocument.createElement('div');
      closeLabel.className = 'close-btn';
      closeLabel.innerHTML = `
        <svg   viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M13.0459 3.05026C12.8507 2.85499 12.5341 2.85499 12.3388 3.05026L8.0962 7.29289L3.85356 3.05026C3.6583 2.85499 3.34171 2.85499 3.14645 3.05026C2.95119 3.24552 2.95119 3.5621 3.14645 3.75736L7.38909 8L3.14645 12.2426C2.95118 12.4379 2.95118 12.7545 3.14645 12.9497C3.34171 13.145 3.65829 13.145 3.85355 12.9497L8.0962 8.70711L12.3388 12.9497C12.5341 13.145 12.8507 13.145 13.0459 12.9497C13.2412 12.7545 13.2412 12.4379 13.0459 12.2426L8.8033 8L13.0459 3.75736C13.2412 3.5621 13.2412 3.24552 13.0459 3.05026Z" fill="currentColor" />
        </svg>
      `;
      $$(closeLabel).on('click', this.closeAccount.bind(this, 'accounts'))
      this.contentElement.appendChild(closeLabel);
    },

    // 切换账号
    changeAccount: function(dom) {
      // The password is the input element previous to the button.
        // curChangeAccount = this.id
        $$(this).addClass('select')
        const listOffset = $$('.saved-passwords-header').offset()
        const accountList = $$('#password-add-account')
        const closeAccountDialog = () => {
          accountList.attr('hidden', true)
          $$(this).removeClass('select')
          $$('#saved-passwords-list-container').css({
            paddingBottom: 0
          })
          curChangeAccount = -1
          document.removeEventListener("click", click);
        }
        const click = (e) => {
          if (!$$(e.target).closest('#password-add-account').length > 0 && !$$(e.target).hasClass('change-account')) {
            closeAccountDialog()
          }
          if ($$(e.target).hasClass('change-account')) {
            $$(this).removeClass('select')
            document.removeEventListener("click", click);
          }
        }
        if (curChangeAccount == this.id) {
          closeAccountDialog()
          return
        }
        curChangeAccount = this.id
        setTimeout(() => {
          document.addEventListener("click", click);
        })
        let html = ''
        this.accounts.forEach((e, index) => {
          const isShow = e.username === this.username
          html += `
            <li class="account-item" data-index="${index}">
              <div class="list-check ${isShow ? 'active' : ''}">
                <svg viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                  <path d="M6.43348 9.92139L12.6561 3.69873L13.5754 4.61797L6.43348 11.7599L1.97412 7.30051L2.89336 6.38127L6.43348 9.92139Z" fill="currentColor" />
                </svg>
              </div>
              <span title=${HTMLescape(e.username)}>${HTMLescape(e.username)}</span>
              <div class="del-account-list-btn">
                <svg   viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                  <path fill-rule="evenodd" clip-rule="evenodd" d="M13.0459 3.05026C12.8507 2.85499 12.5341 2.85499 12.3388 3.05026L8.0962 7.29289L3.85356 3.05026C3.6583 2.85499 3.34171 2.85499 3.14645 3.05026C2.95119 3.24552 2.95119 3.5621 3.14645 3.75736L7.38909 8L3.14645 12.2426C2.95118 12.4379 2.95118 12.7545 3.14645 12.9497C3.34171 13.145 3.65829 13.145 3.85355 12.9497L8.0962 8.70711L12.3388 12.9497C12.5341 13.145 12.8507 13.145 13.0459 12.9497C13.2412 12.7545 13.2412 12.4379 13.0459 12.2426L8.8033 8L13.0459 3.75736C13.2412 3.5621 13.2412 3.24552 13.0459 3.05026Z" fill="currentColor" />
                </svg>
              </div>
            </li>
          `
        })
        accountList.children('.account-list').html(html)
        accountList.attr('hidden', false)
        const top = dom.offset().top - listOffset.top + dom.height()
        const left = dom.offset().left -listOffset.left - accountList.width() + dom.width()
        accountList.css({top, left})
        const self = this
        // 超过父元素
        const fatherH = $$('#saved-passwords-list-container').height()
        const childH = accountList.height()
        if (top + childH > fatherH) {
          $$('#saved-passwords-list-container').css({
            paddingBottom: top + childH - fatherH + 20 + 'px'
          })
        } else {
          $$('#saved-passwords-list-container').css({
            paddingBottom: 0
          })
        }
        $$('#password-add-account .account-list .account-item').unbind("click").click(function(e){
          const index = $$(this).attr('data-index')
          PasswordManager.changeAccount(self.id, index)
          gif("1388.7244.gif")
          accountList.attr('hidden', true)
          closeAccountDialog()
          e.stopPropagation()
        })
        // 删除单个账号
        $$('#password-add-account .account-list .account-item .del-account-list-btn').unbind("click").click(function(e){
          const index = $$(this).parents('.account-item').attr('data-index')
          setTimeout(() => {
            self.closeAccountSingle(index)
          })
          gif('1388.2101.gif')
          accountList.attr('hidden', true)
          closeAccountDialog()
          e.stopPropagation()
        })
        // 添加账号
        $$('#password-add-account .account-footer .add-btn').unbind("click").click(function(e){
          setTimeout(() => {
            // OptionsPage.navigateToPage("passwordPopup");
            OptionsPage.showPageByName('passwordPopup', false)
            $$('#password-popup-overlay .add-account').attr('hidden', false)
          })
          gif('1388.4707.gif')
          accountList.attr('hidden', true)
          closeAccountDialog()
          const name = $$('#password-popup-overlay .account-name')
          name.focus()
          const password = $$('#password-popup-overlay .account-password')
          const inputChange = () => {
            if (name.val() && password.val() && !name.parents('.dlg-text-con').hasClass('error')) {
              // 按钮可点击
              $$('.add-account .sure').removeClass('disabled')
            } else {
              // 按钮不可点击
              $$('.add-account .sure').addClass('disabled')
            }
          }
          const blurName =  () => {
            // 校验账号是否重复
            // self.isSameAccount(name.val())
            if (PasswordManager.isSameAccount(self.url, name.val())) {
              name.parents('.dlg-text-con').addClass('error')
            } else {
              name.parents('.dlg-text-con').removeClass('error')
            }
            inputChange()
          }
          name.bind('blur', blurName)
          name.bind('input propertychange ', inputChange)
          password.bind('input propertychange ', inputChange)
          const resetForm = () => {
            $$('#password-popup-overlay .add-account').attr('hidden', true)
            name.val('')
            password.val('')
            name.parents('.dlg-text-con').removeClass('error')
            $$('.add-account .sure').addClass('disabled')
          }
          PasswordPopupOverlay.sureClick((callBack) => {
            blurName()
            inputChange()
            // 校验是否填写齐全
            if ($$('.add-account .sure').hasClass('disabled')) return
            // 校验是否有错误警告
            if (name.parents('.dlg-text-con').hasClass('error')) return
            chrome.send("addPasswordNewAccout", [
              self.url,
              name.val(),
              password.val()
            ]);
            resetForm()
            callBack()
          })
          PasswordPopupOverlay.cancelClick((callBack) => {
            resetForm()
            callBack()
          })
        })

    },
    isSameAccount: function(name) {
      if (this.accounts) {
        const idx = this.accounts.findIndex((e) => e.username === name)
        if (idx !== -1) {
          return true
        }
      }
      return false
    },
    // 删除账号组
    closeAccount: function(isAccounts = '') {
      if (isAccounts) gif('1388.3091.gif')
      // OptionsPage.navigateToPage("passwordPopup");
      OptionsPage.showPageByName('passwordPopup', false)
      
      $$('#password-popup-overlay .del-account').attr('hidden', false)
      $$('#password-popup-overlay .del-account h4').text('删除确认')
      $$('#password-popup-overlay .del-account .password-pop-content').html(
        `<span>网站 </span>“<i title=${HTMLescape(this.url)}>${HTMLescape(this.url)}</i>”<span> 下的各账号和密码都将被删除！</span>`
      )
      PasswordPopupOverlay.sureClick((callBack) => {
        const delList = this.accounts.map((el) => {
          return {account: el.username, url: el.url}
        })
        chrome.send("removeSavedUrl", delList);
        $$('#password-popup-overlay .del-account').attr('hidden', true)
        callBack()
      })
      PasswordPopupOverlay.cancelClick((callBack) => {
        $$('#password-popup-overlay .del-account').attr('hidden', true)
        callBack()
      })
    },
    // 删除单个账号
    closeAccountSingle: function(index) {
      // The password is the input element previous to the button.
      if (this.accounts.length < 2) {
        this.closeAccount()
      } else {
        // OptionsPage.navigateToPage("passwordPopup");
        OptionsPage.showPageByName('passwordPopup', false)
        $$('#password-popup-overlay .del-account').attr('hidden', false)
        $$('#password-popup-overlay .del-account h4').text('删除确认')
        $$('#password-popup-overlay .del-account .password-pop-content').html(
          `<span>确定删除该账号和密码？</span>`
        )
        PasswordPopupOverlay.sureClick((callBack) => {
          const data = this.accounts[index]
          const delList = [{account: data.username, url: data.url}]
          chrome.send("removeSavedUrl", delList);
          $$('#password-popup-overlay .del-account').attr('hidden', true)
          callBack()
        })
        PasswordPopupOverlay.cancelClick((callBack) => {
          $$('#password-popup-overlay .del-account').attr('hidden', true)
          callBack()
        })
      }
    },
    // 显示密码
    showPassword: function(event) {
      var url = this.url;
      var account = this.username
      gif('1388.7349.gif')
      chrome.send("getPassword", [
        url,
        account,
        "PasswordManager.canShowPassword",
      ]);
    },
    // 复制密码
    copyPassword: function(event) {
      var url = this.url;
      var account = this.username
      gif('1388.7593.gif')
      chrome.send("getPassword", [
        url,
        account,
        "PasswordManager.copyPassword",
      ]);
    },
    // 隐藏密码
    hidePassword: function(passwordInputDiv) {
      // 隐藏
      passwordInputDiv.children('.inactive-password').attr('hidden', true)
      passwordInputDiv.children('.password-invisible').attr('hidden', false)
      passwordInputDiv.children('.password-btns').children('.show-password').attr('hidden', false)
      passwordInputDiv.children('.password-btns').children('.hide-password').attr('hidden', true)
      PasswordManager.hidePassword(this.id)
    },
    /**
     * On-click event handler. Swaps the type of the input field from password
     * to text and back.
     * @private
     */
    onClick_: function(event) {
      // The password is the input element previous to the button.
      var button = event.currentTarget;
      var passwordInput = button.previousSibling;
      if (passwordInput.type == 'password') {
        passwordInput.type = 'text';
        button.textContent = localStrings.getString('passwordHideButton');
      } else {
        passwordInput.type = 'password';
        button.textContent = localStrings.getString('passwordShowButton');
      }
    },

    /**
     * Get and set the URL for the entry.
     * @type {string}
     */
    get url() {
      return this.dataItem.url;
    },
    set url(url) {
      this.dataItem.url = url;
    },

    /**
     * Get and set the username for the entry.
     * @type {string}
     */
    get username() {
      return this.dataItem.username;
    },
    set username(username) {
      this.dataItem.username = username;
    },

    /**
     * Get and set the password for the entry.
     * @type {string}
     */
    get password() {
      return this.dataItem.password;
    },
    set password(password) {
      this.dataItem.password = password;
    },
    get id() {
      return this.dataItem.id;
    },
    set id(id) {
      this.dataItem.id = id;
    },
    get accounts() {
      return this.dataItem.accounts;
    },
    set accounts(accounts) {
      this.dataItem.accounts = accounts;
    },
    get urlReg() {
      return this.dataItem.urlReg;
    },
    set urlReg(urlReg) {
      this.dataItem.urlReg = urlReg;
    },
    get usernameReg() {
      return this.dataItem.usernameReg;
    },
    set usernameReg(usernameReg) {
      this.dataItem.usernameReg = usernameReg;
    },
  };

  /**
   * Creates a new PasswordExceptions list item.
   * @param {Array} entry A pair of the form [url, username].
   * @constructor
   * @extends {Deletable.ListItem}
   */
  function PasswordExceptionsListItem(entry) {
    var el = cr.doc.createElement('div');
    el.dataItem = entry;
    el.__proto__ = PasswordExceptionsListItem.prototype;
    el.decorate();

    return el;
  }

  PasswordExceptionsListItem.prototype = {
    __proto__: DeletableItem.prototype,

    /**
     * Call when an element is decorated as a list item.
     */
    decorate: function() {
      DeletableItem.prototype.decorate.call(this);
      this.contentElement.className = 'exceptions-list-item'

      // The URL of the site.
      var urlLabel = this.ownerDocument.createElement('div');
      urlLabel.className = 'url';
      urlLabel.classList.add('favicon-cell');
      urlLabel.classList.add('weakrtl');
      
      urlLabel.innerHTML = `<a target="_blank" title=${HTMLescape(this.url)} href=${HTMLescape(this.url)}>${this.urlReg || HTMLescape(this.url)}</a>`;
      urlLabel.style.backgroundImage = url('chrome://favicon/' + HTMLescape(this.url));
      this.contentElement.appendChild(urlLabel);
      $$(urlLabel).children('a').on('click', ()=> {gif('1388.1113.gif')})

      var closeLabel = this.ownerDocument.createElement('div');
      closeLabel.className = 'close-btn';
      closeLabel.innerHTML = `
        <svg   viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M13.0459 3.05026C12.8507 2.85499 12.5341 2.85499 12.3388 3.05026L8.0962 7.29289L3.85356 3.05026C3.6583 2.85499 3.34171 2.85499 3.14645 3.05026C2.95119 3.24552 2.95119 3.5621 3.14645 3.75736L7.38909 8L3.14645 12.2426C2.95118 12.4379 2.95118 12.7545 3.14645 12.9497C3.34171 13.145 3.65829 13.145 3.85355 12.9497L8.0962 8.70711L12.3388 12.9497C12.5341 13.145 12.8507 13.145 13.0459 12.9497C13.2412 12.7545 13.2412 12.4379 13.0459 12.2426L8.8033 8L13.0459 3.75736C13.2412 3.5621 13.2412 3.24552 13.0459 3.05026Z" fill="currentColor" />
        </svg>
      `;
      $$(closeLabel).on('click', this.clearUrl.bind(this))
      this.contentElement.appendChild(closeLabel);
    },
    clearUrl: function() {
      // this.deleteItemAtIndex(this.index)
      gif('1388.758.gif')
      PasswordManager.removePasswordException(this.index);
      // chrome.send("removePasswordException", [this.index]);
    },

    /**
     * Get the url for the entry.
     * @type {string}
     */
    get url() {
      return this.dataItem.url;
    },
    set url(url) {
      this.dataItem.url = url;
    },
    get index() {
      return this.dataItem.index;
    },
    set index(index) {
      this.dataItem.index = index;
    },
    get urlReg() {
      return this.dataItem.urlReg;
    },
    set urlReg(urlReg) {
      this.dataItem.urlReg = urlReg;
    }
  };

  /**
   * Create a new passwords list.
   * @constructor
   * @extends {cr.ui.List}
   */
  var PasswordsList = cr.ui.define('list');

  PasswordsList.prototype = {
    __proto__: DeletableItemList.prototype,

    /**
     * Whether passwords can be revealed or not.
     * @type {boolean}
     * @private
     */
    showPasswords_: true,

    /** @inheritDoc */
    decorate: function() {
      DeletableItemList.prototype.decorate.call(this);
    },

    /**
     * Listener for changes on the preference.
     * @param {Event} event The preference update event.
     * @private
     */
    onPreferenceChanged_: function(event) {
      this.showPasswords_ = event.value.value;
      this.redraw();
    },

    /** @inheritDoc */
    createItem: function(entry) {
      return new PasswordListItem(entry, this.showPasswords_);
    },

    /** @inheritDoc */
    deleteItemAtIndex: function(index) {
      var item = this.dataModel.item(index);
      if (item && item.length > 3) {
        // The fourth element, if present, is the original index to delete.
        index = item[3];
      }
      PasswordManager.removeSavedPassword(index);
    },

    /**
     * The length of the list.
     */
    get length() {
      return this.dataModel.length;
    },
  };

  /**
   * Create a new passwords list.
   * @constructor
   * @extends {cr.ui.List}
   */
  var PasswordExceptionsList = cr.ui.define('list');

  PasswordExceptionsList.prototype = {
    __proto__: DeletableItemList.prototype,

    /** @inheritDoc */
    createItem: function(entry) {
      return new PasswordExceptionsListItem(entry);
    },

    /** @inheritDoc */
    deleteItemAtIndex: function(index) {
      PasswordManager.removePasswordException(index);
    },

    /**
     * The length of the list.
     */
    get length() {
      return this.dataModel.length;
    },
  };

  return {
    PasswordListItem: PasswordListItem,
    PasswordExceptionsListItem: PasswordExceptionsListItem,
    PasswordsList: PasswordsList,
    PasswordExceptionsList: PasswordExceptionsList,
  };
});
