// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

cr.define('options', function() {
  const OptionsPage = options.OptionsPage;
  const ArrayDataModel = cr.ui.ArrayDataModel;

  /////////////////////////////////////////////////////////////////////////////
  // PasswordManager class:

  /**
   * Encapsulated handling of password and exceptions page.
   * @constructor
   */
  function PasswordManager() {
    this.activeNavTab = null;
    OptionsPage.call(this,
                     'passwords',
                     templateData.passwordsPageTabTitle,
                     'password-manager');
  }

  cr.addSingletonGetter(PasswordManager);

  PasswordManager.prototype = {
    __proto__: OptionsPage.prototype,

    /**
     * The saved passwords list.
     * @type {DeletableItemList}
     * @private
     */
    savedPasswordsList_: null,
    savedList: [],
    exceptionsList: [],
    firstEnter: {
      saved: true,
      except: true
    },

    /**
     * The password exceptions list.
     * @type {DeletableItemList}
     * @private
     */
    passwordExceptionsList_: null,

    /**
     * The timer id of the timer set on search query change events.
     * @type {number}
     * @private
     */
    queryDelayTimerId_: 0,

    /**
     * The most recent search query, or null if the query is empty.
     * @type {?string}
     * @private
     */
    lastQuery_: null,

    /** @inheritDoc */
    initializePage: function() {
      OptionsPage.prototype.initializePage.call(this);
      $('password-search-box').addEventListener('search',
          this.handleSearchQueryChange_.bind(this));
      this.createSavedPasswordsList_();
      this.createPasswordExceptionsList_();
      // tabs添加点击事件
      $$('.password-tabs').on('click', this.changeTab.bind(this))
      $$('#password-search-close').on('click', this.clearSearch.bind(this))
      $$('.password-add-net').on('click', this.addNet.bind(this))
    },
    changeTab: function(e) {
      if ($$(e.target).hasClass('active') || $$(e.target).parents().hasClass('active')) {
        return
      }
      gif("1388.2995.gif")
      const dom = $$('#passwords-title .password-tabs')
      if ($$(e.target).hasClass('saved') || $$(e.target).parents().hasClass('saved')) {
        // 切换到已保存
        dom[0].classList.add('active')
        dom[1].classList.remove('active')
        $('saved-passwords-list-container').hidden = false
        $('password-exceptions-list-container').hidden = true
        $$('.password-add-net').text('添加网站')
        $$('.password-add-net').removeClass('disabled')
      } else {
        // 切换到不保存
        dom[1].classList.add('active')
        dom[0].classList.remove('active')
        $('saved-passwords-list-container').hidden = true
        $('password-exceptions-list-container').hidden = false
        $$('.password-add-net').text('清空列表')
        if (this.exceptionsList && this.exceptionsList.length) {
          $$('.password-add-net').removeClass('disabled')
        } else {
          $$('.password-add-net').addClass('disabled')
        }
      }
    },
    inputChange: function(dom) {
      return dom.val()
    },
    getUrlDomain: function(url) {
      if (!url || !url.trim()) {
        return ''
      }
      // eslint-disable-next-line
      url = url.split('?')[0]
      const arr = url.split('/')
      const d = url.indexOf('http') > -1 ? arr[2] : arr[0]
      let domain = ''
      if (d) {
        domain = d // 如果
      } else {
        domain = url
      }
      return domain
    },
    // isSameAccount_: function(url, name) {
    //   const domain = url
    //   const index = this.savedList.findIndex((e) => {
    //     const eUrl = e.url
    //     return domain === eUrl
    //   })
    //   if (index !== -1) {
    //     const accounts = this.savedList[index].accounts
    //     if (accounts) {
    //       const idx = accounts.findIndex((e) => e.username === name)
    //       if (idx !== -1) {
    //         return true
    //       }
    //     }
    //   }
    //   return false
    // },
    isSameAccount_: function(url, name) {
      const domain = this.getUrlDomain(url)
      const urlList = this.savedList.filter((e) => {
        const eUrl = this.getUrlDomain(e.url)
        return domain === eUrl
      })
      if (urlList.length) {
        let accounts =  []
        urlList.forEach((el) => {
          accounts = accounts.concat(el.accounts)
        })
        if (accounts.length) {
          const idx = accounts.findIndex((e) => e.username === name)
          if (idx !== -1) {
            return true
          }
        }
      }
      return false
    },
    addNet: function(e) {
      if ($$('.password-add-net').text() === '清空列表') {
        this.clearList()
        return
      }
      gif('1388.5855.gif')
      // OptionsPage.navigateToPage("passwordPopup");
      OptionsPage.showPageByName('passwordPopup', false)
      $$('#password-popup-overlay .add-site').attr('hidden', false)
      $$('#password-popup-overlay .site-url').focus()
      const url = $$('#password-popup-overlay .site-url')
      const name = $$('#password-popup-overlay .site-name')
      const password = $$('#password-popup-overlay .site-password')
      const inputChange = () => {
        if (url.val().trim() && name.val() && password.val() && !(name.parents('.dlg-text-con').hasClass('error') || url.parents('.dlg-text-con').hasClass('error'))) {
          // 按钮可点击
          $$('.add-site .sure').removeClass('disabled')
        } else {
          // 按钮不可点击
          $$('.add-site .sure').addClass('disabled')
        }
      }
      const urlBlur = () => {
        // 校验账号是否重复，网址格式是否正确
        let val = url.val().trim()
        url.val(val)
        if (!val) return
        if (!/^(https?):\/\//.test(val)) {
          val = "http://" + val
          url.val(val);
        }
        const domain = 'http://' + this.getUrlDomain(val)
        // if (!/^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z|]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(val)) { // eslint-disable-line
          if (!/http(s)?:\/\/([\w-]+\.)+[\w-]+(\/[\w- .\/?%&=]*)?/.test(val)) { // eslint-disable-line
          url.parents('.dlg-text-con').addClass('error')
          name.parents('.dlg-text-con').removeClass('error')
        } else if (!/^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z|]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(domain)) {
          url.parents('.dlg-text-con').addClass('error')
          name.parents('.dlg-text-con').removeClass('error')
        } else {
          url.parents('.dlg-text-con').removeClass('error')
          if (this.isSameAccount_(url.val(), name.val())) {
            // 账号重复
            name.parents('.dlg-text-con').addClass('error')
          } else {
            name.parents('.dlg-text-con').removeClass('error')
          }
        }
        inputChange()
      }
      url.bind('blur', urlBlur)
      url.bind('input propertychange ',inputChange)
      const nameBlur =  () => {
        // 校验账号是否重复
        if (this.isSameAccount_(url.val(), name.val())) {
          // 账号重复
          name.parents('.dlg-text-con').addClass('error')
        } else {
          name.parents('.dlg-text-con').removeClass('error')
        }
        inputChange()
      }
      name.bind('blur', nameBlur)
      name.bind('input propertychange ', inputChange)
      password.bind('input propertychange ', inputChange)
      const resetForm = () => {
        $$('#password-popup-overlay .add-site').attr('hidden', true)
        url.val('')
        name.val('')
        password.val('')
        name.parents('.dlg-text-con').removeClass('error')
        url.parents('.dlg-text-con').removeClass('error')
        $$('.add-site .sure').addClass('disabled')
      }
      PasswordPopupOverlay.sureClick((callBack) => {
        urlBlur()
        nameBlur()
        inputChange()
        // 校验是否填写齐全
        if ($$('.add-site .sure').hasClass('disabled')) return
        // 校验是否有错误警告
        if (name.parents('.dlg-text-con').hasClass('error') || url.parents('.dlg-text-con').hasClass('error')) return
        chrome.send("addPasswordNewUrlAccout", [
          url.val(),
          name.val(),
          password.val()
        ]);
        resetForm()
        callBack()
      })
      PasswordPopupOverlay.cancelClick((callBack) => {
        resetForm()
        callBack()
      })
    },
    clearList: function(e) {
      if (!this.exceptionsList || !this.exceptionsList.length) return
      gif('1388.6844.gif')
      // OptionsPage.navigateToPage("passwordPopup");
      OptionsPage.showPageByName('passwordPopup', false)
      $$('#password-popup-overlay .del-account').attr('hidden', false)
      $$('#password-popup-overlay .del-account h4').text('清空列表')
      $$('#password-popup-overlay .del-account .password-pop-content').html(
        `<span>确定要清除全部列表内容吗？</span>`
      )
      PasswordPopupOverlay.sureClick((callBack) => {
        chrome.send("removeAllPasswordExceptions",);
        $$('#password-popup-overlay .del-account').attr('hidden', true)
        callBack()
      })
      PasswordPopupOverlay.cancelClick((callBack) => {
        $$('#password-popup-overlay .del-account').attr('hidden', true)
        callBack()
      })
    },
    clearSearch: function(e) {
      $('password-search-box').value = ''
      $('password-search-box').focus()
    },
    canShowPage: function() {
      return !PersonalOptions.disablePasswordManagement();
    },

    /** @inheritDoc */
    didShowPage: function() {
      // Updating the password lists may cause a blocking platform dialog pop up
      // (Mac, Linux), so we delay this operation until the page is shown.
      chrome.send('updatePasswordLists');
      gif("1388.2995.gif")
      $('password-search-box').focus();
      $$('#subpage-sheet-1').addClass('password-subpage-sheet')
    },
    willHidePage: function() {
      // Updating the password lists may cause a blocking platform dialog pop up
      // (Mac, Linux), so we delay this operation until the page is shown.
      $$('#subpage-sheet-1').removeClass('password-subpage-sheet')
    },

    /**
     * Creates, decorates and initializes the saved passwords list.
     * @private
     */
    createSavedPasswordsList_: function() {
      this.savedPasswordsList_ = $('saved-passwords-list');
      options.passwordManager.PasswordsList.decorate(this.savedPasswordsList_);
      this.savedPasswordsList_.autoExpands = true;
    },

    /**
     * Creates, decorates and initializes the password exceptions list.
     * @private
     */
    createPasswordExceptionsList_: function() {
      this.passwordExceptionsList_ = $('password-exceptions-list');
      options.passwordManager.PasswordExceptionsList.decorate(
          this.passwordExceptionsList_);
      this.passwordExceptionsList_.autoExpands = true;
    },

    /**
     * Handles search query changes.
     * @param {!Event} e The event object.
     * @private
     */
    handleSearchQueryChange_: function(e) {
      if (this.queryDelayTimerId_)
        window.clearTimeout(this.queryDelayTimerId_);
        if ($('password-search-box').value) {
          $('password-search-close').classList.remove('hidden')
        } else {
          $('password-search-close').classList.add('hidden')
        }
      // Searching cookies uses a timeout of 500ms. We use a shorter timeout
      // because there are probably fewer passwords and we want the UI to be
      // snappier since users will expect that it's "less work."
      this.queryDelayTimerId_ = window.setTimeout(
          this.searchPasswords_.bind(this), 250);
    },

    /**
     * Search passwords using text in |password-search-box|.
     * @private
     */
    searchPasswords_: function() {
      this.queryDelayTimerId_ = 0;
      var filter = $('password-search-box').value;
      filter = (filter == '') ? null : filter;
      if (this.lastQuery_ != filter) {
        if (filter) gif("1388.4536.gif")
        this.lastQuery_ = filter;
        // Searching for passwords has the side effect of requerying the
        // underlying password store. This is done intentionally, as on OS X and
        // Linux they can change from outside and we won't be notified of it.
        // chrome.send('updatePasswordLists');
        // 设置元素的显示隐藏
        this.searchSavedPasswordsList_()
        this.searchPasswordExceptionsList_()
      }
    },
    searchSavedPasswordsList_() {
      let entries = []
      if (this.lastQuery_) {
        var query = HTMLescape(this.lastQuery_);
        let newquery = query.replace(/([*.?+$^(){}|\\/])/g, '\\$1') 
        this.savedList.forEach((entry, index) => {
          const username = entry.accounts.findIndex((e) => {
            return HTMLescape(e.username).toUpperCase().indexOf(query.toUpperCase()) >= 0
          })
          
          const rStr = new RegExp(newquery, 'ig')
          if (HTMLescape(entry.url).toUpperCase().indexOf(query.toUpperCase()) >= 0 || username !== -1) {
            entries.push({
              ...entry,
              usernameReg: HTMLescape(entry.username).replace(rStr, '<b>$&</b>'),
              urlReg: HTMLescape(entry.url).replace(rStr, '<b>$&</b>'),
            })
          }
        });
      } else {
        entries = this.savedList
      }
      this.savedPasswordsList_.dataModel = new ArrayDataModel(entries)
      // this.updateListVisibility_(this.savedPasswordsList_)
      if (!entries.length && this.lastQuery_) {
        // search-noData
        $$('#search-noData').attr('hidden', false)
        $$('#search-noData .search-text').text(this.lastQuery_)
        $$('#saved-passwords-list-empty-placeholder').attr('hidden', true)
      } else {
        $$('#search-noData').attr('hidden', true)
        if (!this.savedList.length) {
          $$('#saved-passwords-list-empty-placeholder').attr('hidden', false)
        }
      }
      
    },
    searchPasswordExceptionsList_() {
      let entries = []
      if (this.lastQuery_) {
        var query = HTMLescape(this.lastQuery_);
        let newquery = query.replace(/([*.?+$^(){}|\\/])/g, '\\$1') 
        this.exceptionsList.forEach((entry, index) => {
          const rStr = new RegExp(newquery, 'ig')
          if (HTMLescape(entry.url).toUpperCase().indexOf(query.toUpperCase()) >= 0) {
            entries.push({
              ...entry,
              urlReg: HTMLescape(entry.url).replace(rStr, '<b>$&</b>'),
            })
          }
        });
      } else {
        entries = this.exceptionsList
      }
      this.passwordExceptionsList_.dataModel = new ArrayDataModel(entries)
      // this.updateListVisibility_(this.passwordExceptionsList_)
      if (!entries.length && this.lastQuery_) {
        // search-noData
        $$('#search-noData-exceptions').attr('hidden', false)
        $$('#search-noData-exceptions .search-text').text(this.lastQuery_)
        $$('#password-exceptions-list-empty-placeholder').attr('hidden', true)
      } else {
        $$('#search-noData-exceptions').attr('hidden', true)
        if (!this.exceptionsList.length) {
          $$('#password-exceptions-list-empty-placeholder').attr('hidden', false)
        }
      }
    },
    /**
     * Updates the visibility of the list and empty list placeholder.
     * @param {!List} list The list to toggle visilibility for.
     */
    updateListVisibility_: function(list) {
      var empty = list.dataModel.length == 0;
      var listPlaceHolderID = list.id + '-empty-placeholder';
      list.hidden = empty;
      $(listPlaceHolderID).hidden = !empty;
    },

    /**
     * Updates the data model for the saved passwords list with the values from
     * |entries|.
     * @param {Array} entries The list of saved password data.
     */
    setSavedPasswordsList_: function(entries) {
      // 数据格式 url, name, password, accounts
      let list = []
      const obj = {}
      entries.forEach((e) => {
        const domain = e[0]
        if (obj[domain] || obj[domain] === 0) {
          list[obj[domain]].accounts.push({ url: e[0], username: e[1], password: ''})
        } else {
          obj[domain] = list.length
          e = {
            url: e[0], 
            username: e[1], 
            password: '', 
            accounts: [{url: e[0], username: e[1], password: ''}],
            id: list.length + 1
          }
          if (this.savedList && this.savedList.length) {
            const index = this.savedList.findIndex((el) => {
              return el.url === e.url
            })
            if (index !== -1) {
              const accountIndex = entries.findIndex((el) => {
                return el[0] ===  e.url && el[1] === this.savedList[index].username
              })
              if (accountIndex !== -1) {
                e.username = this.savedList[index].username
                // e.password = this.savedList[index].password
              }
            }
          }
          list.push(e)
        }
      })
      this.savedList = list
      entries = list
      $$('#passwords-title .saved .num').text(list.length)
      this.savedPasswordsList_.dataModel = new ArrayDataModel(entries);
      this.updateListVisibility_(this.savedPasswordsList_);
      if (this.lastQuery_) {
        this.searchSavedPasswordsList_()
      }
      if (this.firstEnter.saved) {
        const len = list.length
        let refer = '0_10'
        if (len > 30) {
          refer = '31_'
        } else if (len > 20) {
          refer = '21_30'
        } else if (len > 10) {
          refer = '11_20'
        }
        gif("1388.2867.gif", {_referer: refer})
        this.firstEnter.saved = false
      }
    },

    /**
     * Updates the data model for the password exceptions list with the values
     * from |entries|.
     * @param {Array} entries The list of password exception data.
     */
    setPasswordExceptionsList_: function(entries) {
      entries = entries.map((e, index) => {
        return {url: e, index: index}
      })
      this.passwordExceptionsList_.dataModel = new ArrayDataModel(entries);
      $$('#passwords-title .exceptions .num').text(entries.length)
      this.updateListVisibility_(this.passwordExceptionsList_);
      this.exceptionsList = entries
      if ((!this.exceptionsList || !this.exceptionsList.length) && !$$('#passwords-title .password-tabs:first').hasClass('active')) {
        $$('.password-add-net').addClass('disabled')
      } else {
        $$('.password-add-net').removeClass('disabled')
      }
      if (this.lastQuery_) {
        this.searchPasswordExceptionsList_()
      }
      if (this.firstEnter.except) {
        const len = entries.length
        let refer = '0_10'
        if (len > 30) {
          refer = '31_'
        } else if (len > 20) {
          refer = '21_30'
        } else if (len > 10) {
          refer = '11_20'
        }
        gif("1388.4381.gif", {_referer: refer})
        this.firstEnter.except = false
      }
    },

    showPassWord: function(item, _info = {}) {
      if (_info.password) {
        // 显示
        item.children('.inactive-password').attr('hidden', false)
        item.children('.inactive-password').val(_info.password)
        item.children('.password-invisible').attr('hidden', true)
        item.children('.password-btns').children('.show-password').attr('hidden', true)
        item.children('.password-btns').children('.hide-password').attr('hidden', false)
        this.savedList[_info.id - 1].password = _info.password
      }
    },
    hidePassword_: function(id) {
      this.savedList[id - 1].password = ''
    },
    // 显示密码
    canShowPassword_: function(entries) {
      // 获取密码
      if (!entries) return;
      var _info = Base64.decode(entries);
      // var _info = entries
      _info = typeof _info === "string" ? JSON.parse(_info) : _info;
      if (_info.url) {
        var item = $$(`.password[data-url="${_info.url}"]`);
        _info.id = item.attr('data-id')
        item && this.showPassWord(item, _info);
      }
    },
    showTips: function(entries) {
      if (!entries) return;
      $$("#copy_success_tips").text(entries)
      $$("#copy_success_tips").css({
        opacity: 1
      })
      setTimeout(function () {
        $$("#copy_success_tips").css({
          opacity: 0
        })
      }, 1500)
    },
    copyPassword_: function(entries) {
      // if (!entries) return;
      // var _info = Base64.decode(entries);
      // _info = typeof _info === "string" ? JSON.parse(_info) : _info;
      // if (_info.password) {
      //   // 复制到粘贴板
      //   let oInputD = $('password-copy-input')
      //   oInputD.value = _info.password
      //   $$('#password-copy-input').val(_info.password)
      //   $$('#password-copy-input').attr('hidden', false)
      //   oInputD.focus()
      //   oInputD.select()
      //   if (navigator.clipboard) {
      //     navigator.clipboard.writeText(_info.password).then(() => {
      //       this.showTips('密码已复制')
      //       $$('#password-copy-input').attr('hidden', true)
      //     }).catch(() => {
      //       document.execCommand("Copy")
      //       this.showTips('密码已复制')
      //       $$('#password-copy-input').attr('hidden', true)
      //     })
      //   } else {
      //     document.execCommand("Copy")
      //     this.showTips('密码已复制')
      //     $$('#password-copy-input').attr('hidden', true)
      //   }
      // }
      this.showTips('密码已复制')
    },
    delSite_: function(entries) {
      if (!entries) return;
      // 返回id，从列表里删除
      if (entries) {
        // 复制到粘贴板
      }
    },
    changeAccount_: function(id, index) {
      if (this.savedList[id -1]) {
        const data = (this.savedList[id -1].accounts || [])[index] || {}
        this.savedList[id -1].password = ''
        this.savedList[id -1].username = data.username
        this.savedList[id -1].url = data.url
        this.searchSavedPasswordsList_()
      }
    },
  };

  /**
   * Call to remove a saved password.
   * @param rowIndex indicating the row to remove.
   */
  PasswordManager.removeSavedPassword = function(rowIndex) {
      chrome.send('removeSavedPassword', [String(rowIndex)]);
  };

  /**
   * Call to remove a password exception.
   * @param rowIndex indicating the row to remove.
   */
  PasswordManager.removePasswordException = function(rowIndex) {
      chrome.send('removePasswordException', [String(rowIndex)]);
  };

  /**
   * Call to remove all saved passwords.
   * @param tab contentType of the tab currently on.
   */
  PasswordManager.removeAllPasswords = function() {
    chrome.send('removeAllSavedPasswords');
  };

  /**
   * Call to remove all saved passwords.
   * @param tab contentType of the tab currently on.
   */
  PasswordManager.removeAllPasswordExceptions = function() {
    chrome.send('removeAllPasswordExceptions');
  };

  PasswordManager.setSavedPasswordsList = function(entries) {
    PasswordManager.getInstance().setSavedPasswordsList_(entries);
  };

  PasswordManager.setPasswordExceptionsList = function(entries) {
    PasswordManager.getInstance().setPasswordExceptionsList_(entries);
  };
  // 显示秘密
  PasswordManager.canShowPassword = function(entries) {
    PasswordManager.getInstance().canShowPassword_(entries);
  };
  // 隐藏密码
  PasswordManager.hidePassword = function(entries) {
    PasswordManager.getInstance().hidePassword_(entries);
  };
  // 复制到粘贴板
  PasswordManager.copyPassword = function(entries) {
    PasswordManager.getInstance().copyPassword_(entries);
  };
   // 删除网址
   PasswordManager.delSite = function(entries) {
    PasswordManager.getInstance().delSite_(entries);
  };
   // 添加网址
   PasswordManager.addSite = function(entries) {
    PasswordManager.getInstance().addSite_(entries);
  };
  // 删除账号
  PasswordManager.delAccount = function(entries) {
    PasswordManager.getInstance().delAccount_(entries);
  };
   // 添加账号
   PasswordManager.addAccount = function(entries) {
    PasswordManager.getInstance().addAccount_(entries);
  };
  // 切换账号
  PasswordManager.changeAccount = function(id, index) {
    PasswordManager.getInstance().changeAccount_(id, index);
  };
  // 是否是相同账号
  PasswordManager.isSameAccount = function(url, account) {
    return PasswordManager.getInstance().isSameAccount_(url, account);
  };
  // Export
  return {
    PasswordManager: PasswordManager
  };

});
